/*
 * Decompiled with CFR 0.152.
 */
package aist.daruma.client.darumaearth;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    private XPathFactory xpathFactory;
    private HashMap<String, NameSpacePair> nameSpaceHash;
    private static XmlUtil util = new XmlUtil();

    public static String getNameSpacePrefix(String key) {
        XmlUtil util = XmlUtil.getInstance();
        NameSpacePair nameSpacePair = util.nameSpaceHash.get(key);
        if (nameSpacePair == null) {
            return null;
        }
        return nameSpacePair.prefix;
    }

    public static String getNameSpaceURL(String key) {
        XmlUtil util = XmlUtil.getInstance();
        NameSpacePair nameSpacePair = util.nameSpaceHash.get(key);
        if (nameSpacePair == null) {
            return null;
        }
        return nameSpacePair.URL;
    }

    private void buildNameSpaceTable() {
        HashMap<String, NameSpacePair> h = new HashMap<String, NameSpacePair>();
        h.put("soap", new NameSpacePair("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"));
        h.put("gml", new NameSpacePair("gml", "http://www.opengis.net/gml"));
        h.put("xlink", new NameSpacePair("xlink", "http://www.w3.org/1999/xlink"));
        h.put("xsd", new NameSpacePair("xsd", "http://www.w3.org/2001/XMLSchema"));
        h.put("misp", new NameSpacePair("misp", "http://www.infosharp.org/misp"));
        h.put("daruma", new NameSpacePair("daruma", "http://staff.aist.go.jp/i.noda/Rescue/DaRuMa/0.0"));
        this.nameSpaceHash = h;
    }

    public static Node getNextSiblingElement(Node node) {
        Node n = node.getNextSibling();
        if (n == null) {
            return null;
        }
        while (n.getNodeType() != 1) {
            if ((n = n.getNextSibling()) != null) continue;
            return null;
        }
        return n;
    }

    public static Node getFirstChildElement(Node node) {
        Node n = node.getFirstChild();
        if (n == null) {
            return null;
        }
        while (n.getNodeType() != 1) {
            if ((n = n.getNextSibling()) != null) continue;
            return null;
        }
        return n;
    }

    public static String getAttributeByName(Node node, String attrName) {
        Node attrNode;
        NamedNodeMap attrMapList = node.getAttributes();
        if (attrMapList != null && (attrNode = attrMapList.getNamedItem(attrName)) != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static Node getNodeByXPath(Node node, String strXPath, NamespaceContext nsContext) throws Exception {
        XmlUtil util = XmlUtil.getInstance();
        XPath xpath = util.xpathFactory.newXPath();
        if (nsContext != null) {
            xpath.setNamespaceContext(nsContext);
        }
        Node resultNode = null;
        try {
            Node n;
            XPathExpression expr = xpath.compile(strXPath);
            Object result = expr.evaluate(node, XPathConstants.NODE);
            resultNode = n = (Node)result;
        }
        catch (XPathExpressionException xpe) {
            System.out.print("Error on XPath evaluation \"");
            System.out.print(strXPath);
            System.out.print("\" ...");
            System.out.println(xpe.getMessage());
            throw xpe;
        }
        return resultNode;
    }

    public static NodeList getNodeListByXPath(Node node, String strXPath, NamespaceContext nsContext) throws Exception {
        XmlUtil util = XmlUtil.getInstance();
        XPath xpath = util.xpathFactory.newXPath();
        if (nsContext != null) {
            xpath.setNamespaceContext(nsContext);
        }
        NodeList resultNodeList = null;
        try {
            XPathExpression expr = xpath.compile(strXPath);
            Object result = expr.evaluate(node, XPathConstants.NODESET);
            resultNodeList = (NodeList)result;
        }
        catch (XPathExpressionException xpe) {
            System.out.print("Error on XPath evaluation \"");
            System.out.print(strXPath);
            System.out.print("\" ...");
            System.out.println(xpe.getMessage());
            throw xpe;
        }
        return resultNodeList;
    }

    public static String getNodeValueByXPath(Node node, String strXPath, NamespaceContext nsContext) throws Exception {
        String value = null;
        Node n = XmlUtil.getNodeByXPath(node, strXPath, nsContext);
        if (n != null && (value = n.getNodeValue()) == null) {
            value = n.getTextContent();
        }
        return value;
    }

    public static void domToFile(Node node, String fileName) {
        try {
            FileOutputStream dst = new FileOutputStream(fileName);
            XmlUtil.domToStream(node, dst);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.out);
        }
    }

    public static void domToStreamResult(Node node, StreamResult result) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource src = new DOMSource(node);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(src, result);
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("    " + tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.out.println("\n** Transformation error");
            System.out.println("    " + te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
    }

    public static void domToWriter(Node node, Writer writer) {
        StreamResult result = new StreamResult(writer);
        XmlUtil.domToStreamResult(node, result);
    }

    public static void domToStream(Node node, OutputStream stream) {
        StreamResult result = new StreamResult(stream);
        XmlUtil.domToStreamResult(node, result);
    }

    public static Node fileToDom(File sourceFile, DocumentBuilder builder) {
        Document node = null;
        try {
            node = builder.parse(sourceFile);
        }
        catch (SAXException sxe) {
            System.out.println("\n** SAXEception   ... fileToDom");
            sxe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("\n** IOXEception   ... fileToDom");
            ioe.printStackTrace();
        }
        return node;
    }

    public static Node streamToDom(InputStream stream, DocumentBuilder builder) {
        Document node = null;
        try {
            node = builder.parse(stream);
        }
        catch (SAXException sxe) {
            System.out.println("\n** SAXEception   ... StreamToDom");
            sxe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("\n** IOXEception   ... StreamToDom");
            ioe.printStackTrace();
        }
        return node;
    }

    private XmlUtil() {
        this.buildNameSpaceTable();
        this.xpathFactory = XPathFactory.newInstance();
    }

    private static XmlUtil getInstance() {
        return util;
    }

    public static void main(String[] args) {
        System.out.println("xlink prefix=" + XmlUtil.getNameSpacePrefix("xlink"));
        System.out.println("daruma URL=" + XmlUtil.getNameSpaceURL("daruma"));
        System.out.println("notexists URL=" + XmlUtil.getNameSpaceURL("notexists"));
    }

    private class NameSpacePair {
        public final String prefix;
        public final String URL;

        public NameSpacePair(String prefix, String URL2) {
            this.prefix = prefix;
            this.URL = URL2;
        }
    }
}

