/**
 * 
 */
package aist.daruma.client.darumaearth;

//import org.apache.commons.cli.*;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.Iterator;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.HelpFormatter;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.ConfigurationException;

/**
 * 
 * コンフィグパラメータを保持する
 */
public class DarumaEarthConfig {
	static final private String DEFAULT_PROPERTIES_FILENAME="etc/defaultDarumaEarth.properties";
	static final private String CONFIGLINE_REGEX_PATTERN="^-{1,2}(\\w+)=([\\S]+)\\s*";
	static final private String CONFIGLINE_REGEX_PATTERN_NOVALUE="^-{1,2}(\\w+)$";	

	static final private String CONFIGKEY_DEBUG="debug";
	
	static final private String CONFIGKEY_DARUMA_HOST="host";
	static final private String CONFIGKEY_DARUMA_PORT="port";
	static final private String CONFIGKEY_VALUE_MAXLEN="valueMaxLen";
	static final private String CONFIGKEY_INTERVAL="interval";
	static final private String CONFIGKEY_LOOPN="loopN";

	static final private String CONFIGKEY_PREFIX="prefix";

	static final private String CONFIGKEY_DEFAULTNAME="defaultName";
	static final private String CONFIGKEY_PRIMARYFEATURE="primaryFeature";
	static final private String CONFIGKEY_LOCATION_XPATH="locationXPath";
	static final private String CONFIGKEY_ID_XPATH="idXPath";
	static final private String CONFIGKEY_DATAREF_XPATH="dataRefXPath";
			
	static final private String CONFIGKEY_DATA_FEATURE="dataFeature";
	static final private String CONFIGKEY_DATAID_XPATH="dataIdXPath";
	static final private String CONFIGKEY_DATA_XPATH="dataXPath";
	static final private String CONFIGKEY_ENCODE_XPATH="encodeXPath";
			
	static final private String CONFIGKEY_TIMESTAMP_XPATH="timestampXPath";
	static final private String CONFIGKEY_TIMESTAMP="timestamp";
			
	static final private String CONFIGKEY_LINKNAME="linkName";
	static final private String CONFIGKEY_KML_OUTPUTDIR="kmlOutputDir";
	static final private String CONFIGKEY_KML_DOCFILE="kmlDocFile";
	static final private String CONFIGKEY_KML_LINKFILE="kmlLinkFile";
	static final private String CONFIGKEY_IMAGEDIR="imageDir";

	static final private String CONFIGKEY_WORKDIR="workDir";
	static final private String CONFIGKEY_OFFSET_X="offsetX";
	static final private String CONFIGKEY_OFFSET_Y="offsetY";
	static final private String CONFIGKEY_OFFSET_Z="offsetZ";
	static final private String CONFIGKEY_SCALE_X="scaleX";
	static final private String CONFIGKEY_SCALE_Y="scaleY";
	static final private String CONFIGKEY_FLIP_XY="flipXY";

	static final private String CONFIGKEY_STYLE_URL="styleURL";
	static final private String CONFIGKEY_ICON_COLOR="iconColor";
	static final private String CONFIGKEY_ICON_SCALE="iconScale";
	static final private String CONFIGKEY_ICON_HREF="iconHref";
	static final private String CONFIGKEY_ICON_METRIC="iconMetric";
	static final private String CONFIGKEY_LABEL_COLOR="labelColor";
	static final private String CONFIGKEY_LABEL_SCALE="labelScale";
	static final private String CONFIGKEY_LINE_COLOR="lineColor";
	static final private String CONFIGKEY_LINE_WIDTH="lineWidth";
	static final private String CONFIGKEY_HELPMESSAGE = "help.message";
	
	static private DarumaEarthConfig confInstance = new DarumaEarthConfig();
	static private Configuration config;

	static public DarumaEarthConfig getConfig() {
		return confInstance;
	}
	
	boolean debug_=false;
	public boolean debug() { return this.debug_;}
    
	public String darumaHost() {return config.getString(CONFIGKEY_DARUMA_HOST);} // darumaServer Hostname or IPaddress  
	public int darumaPort() { return config.getInt(CONFIGKEY_DARUMA_PORT);} // darumaServer service port number
	
	public int valueMaxLen() { return config.getInt(CONFIGKEY_VALUE_MAXLEN); }
	public int interval() {return config.getInt(CONFIGKEY_INTERVAL);}
	public int loopN() { return config.getInt(CONFIGKEY_LOOPN);}
	
	private String prefix() {return config.getString(CONFIGKEY_PREFIX);}
	private String prefixNsStr = null;
	private String prefixUriStr = "";
	
	private void setPrefix() {
		String prefixStr = prefix();
		if (prefixStr == null || prefixStr.equals("")) {
			prefixNsStr = null;
			prefixUriStr = "";
		} else if (prefixStr.contains("=")) {
			if (prefixStr.startsWith("=")) { // "=http://somewhere/"
				prefixNsStr = null;
				prefixUriStr = prefixStr.substring(1);
			} else {							  //   "something=http://somewhere/"
				String[] nsUri = prefixStr.split("=");
				prefixNsStr = nsUri[0];
				prefixUriStr = nsUri[1];
			}
		}
	}
	
	public String prefixNs() { return prefixNsStr; }
	public String prefixUri() {return prefixUriStr; }
	
	public String defaultName() { return config.getString(CONFIGKEY_DEFAULTNAME); }
	public String primaryFeature() { return config.getString(CONFIGKEY_PRIMARYFEATURE);} //
	public String locationXPath() { return config.getString(CONFIGKEY_LOCATION_XPATH); }
	public String idXPath() { return config.getString(CONFIGKEY_ID_XPATH); }
	public String dataRefXPath() { return config.getString(CONFIGKEY_DATAREF_XPATH); }
	
	public String dataFeature() { return config.getString(CONFIGKEY_DATA_FEATURE); }
	public String dataIdXPath() { return config.getString(CONFIGKEY_DATAID_XPATH); }
	public String dataXPath() { return config.getString(CONFIGKEY_DATA_XPATH); }
	public String encodeXPath() { return config.getString(CONFIGKEY_ENCODE_XPATH); }
	
	public String timestampXPath() { return config.getString(CONFIGKEY_TIMESTAMP_XPATH); }
	public boolean timestamp() { return  config.getBoolean(CONFIGKEY_TIMESTAMP); }
	
	public String linkName() { return config.getString(CONFIGKEY_LINKNAME); }
	public String kmlOutputDir() { return config.getString(CONFIGKEY_KML_OUTPUTDIR); }	
	public String kmlDocFile() { return config.getString(CONFIGKEY_KML_DOCFILE); }
	public String kmlLinkFile() { return config.getString(CONFIGKEY_KML_LINKFILE); }
	public String imageDir() { return config.getString(CONFIGKEY_IMAGEDIR); }
	
	public String workDir() { return config.getString(CONFIGKEY_WORKDIR); }
	
	public double offsetX() { return config.getDouble(CONFIGKEY_OFFSET_X); }
	public double offsetY() { return config.getDouble(CONFIGKEY_OFFSET_Y); }
	public double offsetZ() { return config.getDouble(CONFIGKEY_OFFSET_Z); }
	public double scaleX() { return config.getDouble(CONFIGKEY_SCALE_X); }
	public double scaleY() { return config.getDouble(CONFIGKEY_SCALE_Y); }
	public boolean flipXY() { return config.getBoolean(CONFIGKEY_FLIP_XY); }
	
	public String styleURL() { return config.getString(CONFIGKEY_STYLE_URL); }
	public String iconColor() { return config.getString(CONFIGKEY_ICON_COLOR); }
	public double iconScale() { return config.getDouble(CONFIGKEY_ICON_SCALE); }
	public String iconHref() { return config.getString(CONFIGKEY_ICON_HREF); }
	public int iconX() { return iconX; }
	public int iconY() { return iconY; }
	public int iconW() { return iconW; }
	public int iconH() { return iconH; }

	private int iconX;
	private int iconY;
	private int iconW;
	private int iconH;

	private void setIconMetric() {
		String metricStr = config.getString(CONFIGKEY_ICON_METRIC);
		String [] metrics = metricStr.split(":");
		iconX = Integer.parseInt(metrics[0]);
		iconY = Integer.parseInt(metrics[1]);		
		if (metrics.length > 2) {
			iconW = Integer.parseInt(metrics[2]);		
			iconH = Integer.parseInt(metrics[3]);
		}
	}
	
	public String labelColor() { return config.getString(CONFIGKEY_LABEL_COLOR); }
	public double labelScale() { return config.getDouble(CONFIGKEY_LABEL_SCALE); }
	public String lineColor() { return config.getString(CONFIGKEY_LINE_COLOR); }
	public int lineWidth() { return config.getInt(CONFIGKEY_LINE_WIDTH); }
	
	
	/**
	 * コンストラクタ
	 *
	 */
	private DarumaEarthConfig() {
		config = loadDefaultConfig();
		setupOptions();
	}

	/**
	 * コマンドラインを解析して、コンフィグへオーバライドする
	 * @param arg
	 * @return
	 */
	public boolean applyCommandLine(String[] args) {
		CommandLine cmd = parseCommandLine(args);
		Configuration defConfig = config;
		if (cmd != null) {
			if (cmd.hasOption("conf")) {
				String confFileName = cmd.getOptionValue("conf");
				try {
					applyConfFile(confFileName, defConfig);
				} catch (FileNotFoundException fnex) {
					System.out.print("Error on reading configuration file ");
					System.out.println(fnex.getMessage());
					return false;
				} catch (IOException ioex) {
					System.out.print("Read error occured when reading config file ");
					System.out.print(confFileName);
					System.out.println(".");
					System.out.println(ioex.getMessage());
					return false;
				} catch (DarumaEarthConfigException dex) {
					System.out.print("Config file error occured ");
					System.out.print(confFileName);
					System.out.println(".");
					System.out.println(dex.getMessage());
					return false;
					
				}
			}
			
			if (true) {
//				Option[] opts = cmd.getOptions();
//				for (int i=0; i<opts.length;i++) {
//					String optName =opts[i].getOpt();
//					if (!optName.equals(CONFIGKEY_PREFIX) &&
//							!optName.equals("conf") &&
//							!optName.equals("debug") && 
//							!config.containsKey(optName)) {
//						System.out.print("Unknown option ");
//						System.out.println(optName);
//						return false;
//					}
//				}
				
				Iterator keyIter = defConfig.getKeys();
				Configuration tmpConfig = new PropertiesConfiguration();
				while (keyIter.hasNext()) {
					String key = (String)keyIter.next();
					if (cmd.hasOption(key)) {
						if (IsOptionBoolean(key)){
							tmpConfig.setProperty(key, true);
						} else {
							tmpConfig.setProperty(key, cmd.getOptionValue(key));
						}
					} else {
						tmpConfig.setProperty(key, defConfig.getProperty(key));						
					}
				}
				defConfig = tmpConfig;
			} else {
				if (cmd.hasOption(CONFIGKEY_DARUMA_HOST)) {
					String darumaHost = cmd.getOptionValue(CONFIGKEY_DARUMA_HOST);
					defConfig.setProperty(CONFIGKEY_DARUMA_HOST, darumaHost);
				}

				if (cmd.hasOption(CONFIGKEY_DARUMA_PORT)) {
					String portStr = cmd.getOptionValue(CONFIGKEY_DARUMA_PORT); 
					int darumaPort = Integer.parseInt(portStr);
					defConfig.setProperty(CONFIGKEY_DARUMA_PORT, darumaPort);
				}

				if (cmd.hasOption(CONFIGKEY_PRIMARYFEATURE)) {
					String primaryFeature= cmd.getOptionValue(CONFIGKEY_PRIMARYFEATURE);
					defConfig.setProperty(CONFIGKEY_PRIMARYFEATURE, primaryFeature);
				}

				if (cmd.hasOption(CONFIGKEY_LOCATION_XPATH)) {
					String locationXPath= cmd.getOptionValue(CONFIGKEY_LOCATION_XPATH);
					defConfig.setProperty(CONFIGKEY_LOCATION_XPATH, locationXPath);
				}

				if (cmd.hasOption(CONFIGKEY_LOOPN)) {
					String loopN = cmd.getOptionValue(CONFIGKEY_LOOPN);
					defConfig.setProperty(CONFIGKEY_LOOPN, loopN);
				}
			}
			
			
			if (cmd.hasOption(CONFIGKEY_PREFIX)) {
				String prefix= cmd.getOptionValue(CONFIGKEY_PREFIX);
				defConfig.setProperty(CONFIGKEY_PREFIX,prefix);				
			}
			
			if (cmd.hasOption(CONFIGKEY_DEBUG)) {
				this.debug_ = true;
				System.out.println("debug enabled");
			}
			

			config = defConfig;
			
			setPrefix();
			setIconMetric();
			
			return true;
		}
		
		return false;
	}

	private Configuration loadDefaultConfig()  {
		String configFileName = DEFAULT_PROPERTIES_FILENAME;
		PropertiesConfiguration defConfig = null;		
		try {
			defConfig = new PropertiesConfiguration(configFileName);
			AbstractConfiguration absConfig = (AbstractConfiguration)defConfig;
			absConfig.setThrowExceptionOnMissing(true);	

			// check by just reading
			String strVal = null;
			int intVal = 0;
			double dblVal = 0.0;
			boolean boolVal = false;

			strVal = defConfig.getString(CONFIGKEY_DARUMA_HOST);
			intVal = defConfig.getInt(CONFIGKEY_DARUMA_PORT);

			intVal = defConfig.getInt(CONFIGKEY_VALUE_MAXLEN);
			intVal = defConfig.getInt(CONFIGKEY_INTERVAL);
			intVal = defConfig.getInt(CONFIGKEY_LOOPN);

			try {
				strVal = defConfig.getString(CONFIGKEY_PREFIX);
			} catch (NoSuchElementException nse) {
				//just ignore NoSuchElementException on reading "prefix"
			}
			
			strVal = defConfig.getString(CONFIGKEY_DEFAULTNAME); //"defaultName";	
			strVal = defConfig.getString(CONFIGKEY_PRIMARYFEATURE); //"senseDataInfo";
			strVal = defConfig.getString(CONFIGKEY_LOCATION_XPATH);//"./location";
			strVal = defConfig.getString(CONFIGKEY_ID_XPATH); //"./@gml:id";
			strVal = defConfig.getString(CONFIGKEY_DATAREF_XPATH); //"resultOf/@xlink:href";

			strVal = defConfig.getString(CONFIGKEY_DATA_FEATURE); //"sensedDataEntity";
			strVal = defConfig.getString(CONFIGKEY_DATAID_XPATH); //"@gml:id";
			strVal = defConfig.getString(CONFIGKEY_DATA_XPATH); //"data";
			strVal = defConfig.getString(CONFIGKEY_ENCODE_XPATH); //"encoding";

			strVal = defConfig.getString(CONFIGKEY_TIMESTAMP_XPATH); //"./message/timestamp/text()";
			boolVal = defConfig.getBoolean(CONFIGKEY_TIMESTAMP);

			strVal = defConfig.getString(CONFIGKEY_LINKNAME); //"darumaEarth";
			strVal = defConfig.getString(CONFIGKEY_KML_OUTPUTDIR);
			strVal = defConfig.getString(CONFIGKEY_KML_DOCFILE); //"doc.kml";
			strVal = defConfig.getString(CONFIGKEY_KML_LINKFILE); //"link.kml";
			strVal = defConfig.getString(CONFIGKEY_IMAGEDIR); //"image/";

			strVal = defConfig.getString(CONFIGKEY_WORKDIR); // "./DarumaEarthWork";
			dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_X);
			dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_Y);
			dblVal = defConfig.getDouble(CONFIGKEY_OFFSET_Z);
			dblVal = defConfig.getDouble(CONFIGKEY_SCALE_X);
			dblVal = defConfig.getDouble(CONFIGKEY_SCALE_Y);
			boolVal = defConfig.getBoolean(CONFIGKEY_FLIP_XY);

			strVal = defConfig.getString(CONFIGKEY_STYLE_URL); //"root://styles#default+icon=>0x307";
			strVal = defConfig.getString(CONFIGKEY_ICON_COLOR); //"7fffffff";
			dblVal = defConfig.getDouble(CONFIGKEY_ICON_SCALE);
			strVal = defConfig.getString(CONFIGKEY_ICON_HREF); // "root://icons/palette-4.png";
			strVal = defConfig.getString(CONFIGKEY_ICON_METRIC); // 192:64:32:32
			strVal = defConfig.getString(CONFIGKEY_LABEL_COLOR);
			dblVal = defConfig.getDouble(CONFIGKEY_LABEL_SCALE);
			strVal = defConfig.getString(CONFIGKEY_LINE_COLOR);
			intVal = defConfig.getInt(CONFIGKEY_LINE_WIDTH);

			absConfig.setThrowExceptionOnMissing(false);	
			
		} catch (NoSuchElementException nse) {
			System.out.print("Error on default configuration file ");
			System.out.print(configFileName);
			System.out.print(":");
			System.out.println(nse.getMessage());
			System.exit(-1);
		} catch (ConfigurationException ce) {
			System.out.print("Error on reading ");
			System.out.print(configFileName);
			System.out.print(":");
			System.out.println(ce.getMessage());
			System.exit(-1);
		}

		return defConfig;
	}
	
	private Options options_;
	
	private boolean IsOptionBoolean(String key) {
		boolean result = false;
		String prop = config.getString(key+".isboolean");
		if (prop != null && 
				(prop.equals("yes") ||prop.equals("true"))) {
			result = true;
		}
		return result;
	}

	private String getOptionArgName(String key) {
		String argName = config.getString(key+".argname");
		if (argName == null) {
			argName = key;
		}
		return argName;
	}
	
	private String getOptionDescription(String key, String val) {
		String description = config.getString(key+".description");
		if (description == null) {
			description = " : ("+val+")";
		} else {
			description = " : "+description;
		}
		return description;
	}


	/**
	 *  コマンドラインオプションの定義
	 * @return Options
	 */
	private void setupOptions() {
		Options options = new Options();

		Iterator keyIter = config.getKeys();
		while (keyIter.hasNext()) {
			String key = (String)keyIter.next();
			String val = config.getString(key);
			if ( !key.contains(".")) {
				String description = getOptionDescription(key, val);
				Option opt;
				if (IsOptionBoolean(key)) {
					opt = OptionBuilder.withDescription(description).create(key);			
				} else {
					String argName = getOptionArgName(key);
					opt = OptionBuilder.hasArg().withArgName(argName).withDescription(description).create(key);
				}
				options.addOption(opt);
			}
		}

		
		Option optDebug 
		=	OptionBuilder
			.withDescription("for verbose output")
			.create("debug");
		options.addOption(optDebug);
		
		Option optConf 
		=	OptionBuilder
			.hasArg(true)
			.withArgName("filename")
			.withDescription(" : config file")
			//.isRequired()
			.create("conf");
	options.addOption(optConf);

	Option optPrefix
	=	OptionBuilder
		.hasArg(true)
		.withArgName(getOptionArgName(CONFIGKEY_PREFIX))
		.withDescription(getOptionDescription(CONFIGKEY_PREFIX, null))
		.create(CONFIGKEY_PREFIX);
	options.addOption(optPrefix);

		
		options_ = options;
	}

	public void printUsage() {
		String helpMessage = config.getString(CONFIGKEY_HELPMESSAGE);
		if (helpMessage != null) {
			System.out.println(helpMessage);
		} else {
			HelpFormatter help = new HelpFormatter();		
			help.printHelp("DarumaEarth -conf <configfile> [<options>...]","Options:", options_, "",false);		
		}
	}
	/**
	 * コマンドラインの解析。
	 * @param args
	 * @return
	 */
	private CommandLine parseCommandLine(String[] args) {
		CommandLineParser parser = new GnuParser();
	
		CommandLine cmd = null;
		
		try {
			 cmd = parser.parse( options_, args);
			 if (cmd != null && cmd.getOptions().length == 0 ) {
				 printUsage();
				 cmd = null;
			 }
		} catch ( ParseException e) {
			System.out.println(e.getMessage());
			printUsage();
 		}
		
		return cmd;
	}
	
	private void applyConfFile(String confFileName, Configuration conf) 
	throws FileNotFoundException,IOException, DarumaEarthConfigException {
		FileReader reader = new FileReader(confFileName);
		LineNumberReader lnReader = new LineNumberReader(reader);
		
		// config file is like
		//   --<key>=<value>
		// or
		//    --<key>     # --timestamp or --filpXY

		Pattern confPattern = Pattern.compile(CONFIGLINE_REGEX_PATTERN);
		Pattern confPatternNoValue = Pattern.compile(CONFIGLINE_REGEX_PATTERN_NOVALUE);
		String lineStr;
		while ((lineStr = lnReader.readLine()) != null) {
			
			// skip empty or comment line
			if (lineStr.equals("") || lineStr.startsWith("#")) {
				continue;
			}

			int lineNum = lnReader.getLineNumber();
			Matcher matcher =  confPattern.matcher(lineStr);
			Matcher matcherNoValue =  confPatternNoValue.matcher(lineStr);
			boolean error = false;
			if (matcher.matches() && matcher.groupCount() >= 2) {
				String key = matcher.group(1);
				String value = matcher.group(2);
				
				if (conf.containsKey(key) || key.equals(CONFIGKEY_PREFIX) ) {
					conf.setProperty(key, value);
					if (key.equals(CONFIGKEY_ICON_METRIC)) {
						setIconMetric();
					}
				} else {
					error = true;
				}
			} else if (matcherNoValue.matches()){
				String key = matcherNoValue.group(1);
				if (conf.containsKey(key)) {
					if (IsOptionBoolean(key)) {
						conf.setProperty(key, true);
					} else {
						error = true;						
					}
				} else {
					error = true;
				}
			}
			
			if (error) {
				StringBuilder sb = new StringBuilder();
				sb.append("Illeagal configuration at");
				sb.append(lineNum);
				sb.append(" : ");
				sb.append(lineStr);
				throw new DarumaEarthConfigException(sb.toString());
			}
		}
	}

	
}
