package aist.daruma.client.darumaearth;

import java.util.Iterator;
import java.util.HashMap;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

public class DmlNamespaceContext implements NamespaceContext {
// TODO: map 使って登録しよう	
	private HashMap<String,String> nsMap = new HashMap<String,String>();
	
	// original method
	public void registerNamespace(String prefix, String uri) throws IllegalArgumentException {
		if ( prefix == null || uri == null) {
			throw new IllegalArgumentException();
		}
		
		nsMap.put(prefix,uri);
	}
	
	private void registerDefaults() {
		registerNamespace(XMLConstants.XML_NS_PREFIX, XMLConstants.XML_NS_URI);
		registerNamespace(XMLConstants.XMLNS_ATTRIBUTE, XMLConstants.XMLNS_ATTRIBUTE_NS_URI);
		registerNamespace("dml","http://www.infosharp.org/schemas/dml");
		//registerNamespace("","http://www.infosharp.org/schemas/dml");
	}
	
	public DmlNamespaceContext() {
		registerDefaults();
	}
	
	// followings are implementation of NamespaceContext interface
	public String getNamespaceURI(String prefix) {
//		System.out.println("getNamespaceURI("+prefix+")"); // 接頭辞が憑いていると呼ばれるようだい
		
		if (nsMap.containsKey(prefix)){
			String uri = nsMap.get(prefix);
			return uri;
		}
		
		return XMLConstants.NULL_NS_URI;
	}
	
	public String getPrefix(String uri) {
		System.out.println("getPrefix("+uri+")"); 
		throw new UnsupportedOperationException();
	}
	
	public Iterator getPrefixes() {
		return getPrefixes(null);
	}

	public Iterator getPrefixes(String uri) {
		System.out.println("getPrefixS("+uri+")"); 
		throw new UnsupportedOperationException();		
	}
}
