package aist.daruma.client.darumaearth;

import org.w3c.dom.Node;
import javax.xml.namespace.NamespaceContext;

public class GmlBox extends GmlPolygon {
	static final protected String tagName = "Box";

	public String gmlTagName() {
		return tagName;
	}
	

	public GmlBox() {
		super();
	}
	
	protected void scanGmlBodyAndAddContents(Node xmlNode, NamespaceContext nsContext, Object crs) throws Exception {
		GmlCurve curve = GmlCurve.scanGmlBody(xmlNode, nsContext, crs);
		
		GmlPoint p0 = curve.getPointAt(0);
		GmlPoint p1 = curve.getPointAt(1);
		
		double x0 = p0.getX();
		double y0 = p0.getY();
		double x1 = p1.getX();
		double y1 = p1.getY();
		
		GmlLinearRing ring = new GmlLinearRing();
		ring.addPoint(new GmlPoint(x0,y0));
		ring.addPoint(new GmlPoint(x0,y1));
		ring.addPoint(new GmlPoint(x1,y1));
		ring.addPoint(new GmlPoint(x1,y0));
		ring.addPoint(new GmlPoint(x0,y0));

		clear();
		this.setExterior(ring);

	}
	
	static public GmlBox scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object crs) throws Exception {
		GmlBox box = new GmlBox();
		box.scanGmlBodyAndAddContents(xmlNode, nsContext, crs);
		return box;
	}
}
