package aist.daruma.client.darumaearth;

import java.io.OutputStream;
import java.io.InputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.io.File;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.namespace.NamespaceContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;


public class XmlUtil {
	
	private XPathFactory	xpathFactory;	

	static public String getNameSpacePrefix(String key) {
		XmlUtil util = XmlUtil.getInstance();
		NameSpacePair nameSpacePair = util.nameSpaceHash.get(key);
		if (nameSpacePair == null) {
			return null;
		}
		return nameSpacePair.prefix;
	}

	static public String getNameSpaceURL(String key) {
		XmlUtil util = XmlUtil.getInstance();
		NameSpacePair nameSpacePair = util.nameSpaceHash.get(key);
		if (nameSpacePair == null) {
			return null;
		}
		return nameSpacePair.URL;
	}
	
	private class NameSpacePair {
		final public String prefix;
		final public String URL;
		public NameSpacePair(String prefix, String URL){
			this.prefix = prefix;
			this.URL = URL;
		}
	}

	private HashMap<String,NameSpacePair> nameSpaceHash;

	private void buildNameSpaceTable() {
		// TODO: ファイルからの読みこみを検討する
		HashMap<String,NameSpacePair> h = new HashMap<String,NameSpacePair>();
		h.put("soap",  new NameSpacePair("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"));
		h.put("gml",   new NameSpacePair("gml",      "http://www.opengis.net/gml"));
		h.put("xlink", new NameSpacePair("xlink",	   "http://www.w3.org/1999/xlink"));
		h.put("xsd",   new NameSpacePair("xsd",	   "http://www.w3.org/2001/XMLSchema"));
		h.put("misp",  new NameSpacePair("misp",	   "http://www.infosharp.org/misp"));
		h.put("daruma",new NameSpacePair("daruma",   "http://staff.aist.go.jp/i.noda/Rescue/DaRuMa/0.0"));
		nameSpaceHash = h;
	}
	
	static public Node getNextSiblingElement(Node node) {
		Node n = node.getNextSibling();
		
		if ( n == null) {
			return null;
		}
		
		while ( n.getNodeType() != Node.ELEMENT_NODE) {
			n = n.getNextSibling();
			if (n == null) {
				return null;
			}
		}
		
		return n;
			
	}
	static public Node getFirstChildElement(Node node) {
		Node n = node.getFirstChild();
		
		if ( n == null) {
			return null;
		}
		
		while ( n.getNodeType() != Node.ELEMENT_NODE) {
			n = n.getNextSibling();
			if (n == null) {
				return null;
			}
		}
		
		return n;
			
	}
	
	static public String getAttributeByName(Node node, String attrName) {
		NamedNodeMap attrMapList = node.getAttributes();
	
		if (attrMapList != null) {
			Node attrNode = attrMapList.getNamedItem(attrName);
			if (attrNode != null) {
				return attrNode.getNodeValue();
			}
		}
		return null;
	}
	
	
	static public Node getNodeByXPath(Node node,String strXPath, NamespaceContext nsContext) throws Exception {
		XmlUtil util = XmlUtil.getInstance();		
		XPath xpath = util.xpathFactory.newXPath();
		if (nsContext != null) {
			xpath.setNamespaceContext(nsContext);
		}
		
		Node resultNode = null;
		try {
			XPathExpression expr = xpath.compile(strXPath);

			Object result = expr.evaluate(node, XPathConstants.NODE);
			Node n = (Node) result;

			resultNode = n;	
		} catch (XPathExpressionException xpe) {
			System.out.print("Error on XPath evaluation \"");
			System.out.print(strXPath);
			System.out.print("\" ...");
			System.out.println(xpe.getMessage());
			throw xpe;
		}
		
		return resultNode;
	}
	
	static public NodeList getNodeListByXPath(Node node,String strXPath, NamespaceContext nsContext) 
	  throws Exception {
		XmlUtil util = XmlUtil.getInstance();		
		XPath xpath = util.xpathFactory.newXPath();
		if (nsContext != null) {
			xpath.setNamespaceContext(nsContext);
		}
		
		NodeList resultNodeList = null;
		try {
			XPathExpression expr = xpath.compile(strXPath);

			Object result = expr.evaluate(node, XPathConstants.NODESET);
			resultNodeList = (NodeList) result;
		} catch (XPathExpressionException xpe) {
			System.out.print("Error on XPath evaluation \"");
			System.out.print(strXPath);
			System.out.print("\" ...");
			System.out.println(xpe.getMessage());
			throw xpe;
		}
		
		return resultNodeList;
	}
	
	static public String getNodeValueByXPath(Node node,String strXPath, NamespaceContext nsContext) 
	 throws Exception {
		String value = null;
		Node n = getNodeByXPath(node, strXPath, nsContext);

		if ( n != null) {
			value = n.getNodeValue();
			/* !!! [[07/12/04 11:36 I.Noda]] !!! 
			 * add follows in order to get element value.
			 * getNodeValue() works well only for attribute.
			 */
			if(value == null) {
			    value = n.getTextContent() ;
			}
		}

		return value;
	}
	

	/**
	 * for debugging purpose . Output DOMtree to file
	 * @param node : DOM node
	 * @param fileName : output fileName
	 */
	static public void domToFile(Node node, String fileName) {
		try { 
			FileOutputStream dst = new FileOutputStream(fileName);
			domToStream(node, dst);
		} catch (FileNotFoundException e) {
			// TODO:
			e.printStackTrace(System.out);
		}
	}
	
	static public void domToStreamResult(Node node, StreamResult result) {
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();
			Transformer transformer = tFactory.newTransformer();
			
			DOMSource src = new DOMSource(node);
			
			// make indentation (for human readability, so this is not necessary)
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			// supress <?xml version..?> line to output
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,"yes"); 
			
			transformer.transform(src,result);
			
		} catch (TransformerConfigurationException tce) {
			// Error generated by the parser
			System.out.println("\n** Transformer Factory error");
			System.out.println("    " + tce.getMessage());
			Throwable x = tce;
			if ( tce.getException() != null) {
				x = tce.getException();
			}
			x.printStackTrace();
			
		} catch (TransformerException te) {
			System.out.println("\n** Transformation error");
			System.out.println("    " + te.getMessage());
			// Use the contained exception, if any
			Throwable x = te;
			if ( te.getException() != null) {
				x = te.getException();
			}
			x.printStackTrace();
		
		}
		
	}
	
	/**
	 * Output DOM tree to writer
	 * @param node
	 * @param writer
	 */
	static public void domToWriter(Node node, Writer writer) {
		StreamResult result = new StreamResult(writer);
		domToStreamResult(node,result);
	}

	/**
	 * Output DOM tree to stream
	 * @param node
	 * @param stream
	 */
	static public void domToStream(Node node, OutputStream stream) {
		StreamResult result = new StreamResult(stream);
		domToStreamResult(node,result);
	}

	static public Node fileToDom(File sourceFile, DocumentBuilder builder) {
		Node node = null;
		try {
			node = builder.parse(sourceFile);
		} catch(SAXException sxe) {
			System.out.println("\n** SAXEception   ... fileToDom");
			sxe.printStackTrace();			
		} catch (IOException ioe) {
			System.out.println("\n** IOXEception   ... fileToDom");
			ioe.printStackTrace();
		}

		return node;
	}
	
	static public Node streamToDom(InputStream stream, DocumentBuilder builder) {
		Node node = null;
		try {
			node = builder.parse(stream);
		} catch(SAXException sxe) {
			System.out.println("\n** SAXEception   ... StreamToDom");
			sxe.printStackTrace();			
		} catch (IOException ioe) {
			System.out.println("\n** IOXEception   ... StreamToDom");
			ioe.printStackTrace();

		}

		return node;
	}

	
	static private XmlUtil util = new XmlUtil();
	private XmlUtil() {
		buildNameSpaceTable();
		// xpath related
		xpathFactory  = XPathFactory.newInstance();
	}

	static private XmlUtil getInstance() {
		return XmlUtil.util;
	}

	static public void main(String[] args) {
		// misp util test
		System.out.println("xlink prefix="+XmlUtil.getNameSpacePrefix("xlink"));
		System.out.println("daruma URL="+XmlUtil.getNameSpaceURL("daruma"));
		System.out.println("notexists URL="+XmlUtil.getNameSpaceURL("notexists"));

	}
}
