/**
 * darumaEarth メインクラス 
 */
package aist.daruma.client.darumaearth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * 
 *
 */
public class DarumaEarth {
	
	private DarumaEarthConfig conf;
	private String kmlOutDirName;
	private File kmlOutFile;
	
	/**
	 * 
	 *
	 */
	public DarumaEarth() {
		conf = DarumaEarthConfig.getConfig();
	}
	
	/**
	 * @param args
	 */
	public void execute(String[] args) throws Exception {
		if (conf.applyCommandLine(args)) {
			if (conf.debug()) {
				System.out.println("darumaServer = "+conf.darumaHost()+":"+conf.darumaPort());
			}
			
			
			// make ready working directories 
			preExec();
			
			int execCount = 0;
			while (true) {
				executeOnce();
				execCount++;
				if (conf.loopN() > 0 && execCount >= conf.loopN()) {
					// exit loop!
					break;
				}
				
				if (conf.debug()) {
					System.out.print("(Sleeping ");
					System.out.print(conf.interval());
					System.out.print(" seconds...");
				}
				sleep(conf.interval() *1000); 
				if (conf.debug()) {
					System.out.println("Wake Up.)");
				}
			}
			
			// remove temporary files and directory
			postExec();
			
		} else { // コマンドラインにエラー
			System.exit(-1);
		}
		if (conf.debug()) {
			System.out.println("");
			System.out.println("done.");
		}
	}
	
	private synchronized void sleep(int timeout) {
		try {
			wait(timeout);
		} catch (InterruptedException e) {
			// just ignore
		}
	}

	private void executeOnce() throws Exception {
		String reqFileName;		
		String resFileName;

		try {
			File workDir = new File(conf.workDir()); 
			File reqFile = File.createTempFile("request", ".xml", workDir);
			reqFile.deleteOnExit();
			reqFileName = reqFile.getCanonicalPath(); //"tmpreq.xml";
			
			File resFile = File.createTempFile("response", ".xml", workDir);
			resFile.deleteOnExit();
			resFileName = resFile.getCanonicalPath(); //"tmpreq.xml";
		} catch (Exception e){
			System.out.print("Error on making temporary files...");
			System.out.println(e.getMessage());
			throw e;
		}

		MispRequestBuilder reqBuilder = new MispRequestBuilder();
		try {

			reqBuilder.genGetFeatureRequestToFile(reqFileName, conf.primaryFeature(),conf.prefixNs(),conf.prefixUri());				
			MispSOAPClient client = new MispSOAPClient();
			FileInputStream request = new FileInputStream(reqFileName); //"request_test.xml";
			FileOutputStream response = new FileOutputStream(resFileName); //"response_test.xml";

			client.sendRequest(conf.darumaHost(), conf.darumaPort(), request, response);
			response.close();
		} catch (Exception e) {
			System.out.print("Error on misp request to DaRuMa server...");
			System.out.println(e.getMessage());
			throw e;
		}

		try {
			FileInputStream response_src = new FileInputStream(resFileName); //"response_test.xml");
			KMLConverter converter = new KMLConverter(reqBuilder);

			File kmlOutDir = new File(conf.kmlOutputDir());
			File kmlOutTempFile = File.createTempFile("kmltmp", ".kml", kmlOutDir);
			kmlOutTempFile.deleteOnExit();
			FileOutputStream kmlout = new FileOutputStream(kmlOutTempFile.getCanonicalPath()); //"test.kml";
			converter.convert(conf.primaryFeature(),conf.locationXPath(), response_src, kmlout);
			kmlout.close();
			kmlOutFile.delete();
			kmlOutTempFile.renameTo(kmlOutFile);
		} catch (Exception e) {
			System.out.print("Error on converting to kml file...");
			System.out.println(e.getMessage());
			throw e;
		}
	}

	private void makeLinkKmlFile() throws FileNotFoundException,IOException {
		String kmlOutFileName = kmlOutFile.getCanonicalPath();
		String kmlLinkFileName = kmlOutDirName + conf.kmlLinkFile();
		FileOutputStream kmlLinkFileStream = new FileOutputStream(kmlLinkFileName); 
		OutputStreamWriter out = new OutputStreamWriter(kmlLinkFileStream,"UTF8");
		int interval = conf.interval();
		out.write(KMLConverter.KMLROOT_NODE_STR);
		out.write("\n");
		out.write("  <NetworkLink>\n");
		out.write("    <name></name>\n");
		out.write("    <Link>\n");
		out.write("      <href>"); out.write(kmlOutFileName); out.write("</href>\n");
		out.write("      <refreshMode>onInterval</refreshMode>\n");
		out.write("      <refreshInterval>"); out.write(Integer.toString(interval)); out.write("</refreshInterval>\n");				
		out.write("    </Link>\n");
		out.write("  </NetworkLink>\n");
		out.write("</kml>\n");
		out.close();
		kmlLinkFileStream.close();

	}

	private void preExec() throws Exception {
		File workDir = new File(conf.workDir());
		workDir.mkdirs();
		workDir.deleteOnExit();
		File kmlOutputDir = new File(conf.kmlOutputDir());
		kmlOutputDir.mkdirs();

		kmlOutDirName = conf.kmlOutputDir();
		if (!kmlOutDirName.endsWith(File.separator)) {
			kmlOutDirName += File.separator;
		}
		
		String kmlOutFileName = kmlOutDirName + conf.kmlDocFile();
		kmlOutFile = new File(kmlOutFileName); 

		try {
			makeLinkKmlFile();
		} catch (Exception e) {
			System.out.print("Error on make link.kml file. ");
			System.out.println(e.getMessage());
			throw e;
		}
		
	}

	private void postExec() {
		kmlOutFile = null;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		DarumaEarth darumaEarth = new DarumaEarth();
		try {
			darumaEarth.execute(args);
		} catch (Exception e) {
			e.printStackTrace();			
		}
	}

}
