package aist.daruma.client.darumaearth;

import java.util.Iterator;
import java.util.HashMap;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;


public class DarumaEarthlNamespaceContext implements NamespaceContext {
	
	private HashMap<String,String> nsMap = new HashMap<String,String>();
        /* !!! [[07/12/04 11:36 I.Noda]] !!! */
        private HashMap<String,String> reverseMap = new HashMap<String,String>();
	
	// original method
	public void registerNamespace(String prefix, String uri) throws IllegalArgumentException {
	    //	    System.out.println("ns:" + prefix + "=" + uri) ;
		if ( prefix == null || uri == null) {
			throw new IllegalArgumentException();
		}

		nsMap.put(prefix,uri);

		/* !!! [[07/12/04 11:36 I.Noda]] !!! */
		if (prefix.equals("")) {
		    /* !!! [[07/12/04 11:36 I.Noda]] !!! 
		     * ??? add null entry for defaultNS
		     */
		    nsMap.put(null,uri) ;

		    reverseMap.put(uri,null) ;
		} else {
		    reverseMap.put(uri,prefix) ;
		}
	}
	
	private void registerDefaults() {
		registerNamespace(XMLConstants.XML_NS_PREFIX, XMLConstants.XML_NS_URI);
		registerNamespace(XMLConstants.XMLNS_ATTRIBUTE, XMLConstants.XMLNS_ATTRIBUTE_NS_URI);
		registerNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
		registerNamespace("gml",      "http://www.opengis.net/gml");
		registerNamespace("xlink",	   "http://www.w3.org/1999/xlink");
		registerNamespace("xsd",	   "http://www.w3.org/2001/XMLSchema");
		registerNamespace("misp",	   "http://www.infosharp.org/misp");
		registerNamespace("daruma",   "http://staff.aist.go.jp/i.noda/Rescue/DaRuMa/0.0");
	}
	
	public DarumaEarthlNamespaceContext() {
		registerDefaults();
	}
	
	// followings are implementation of NamespaceContext interface
	public String getNamespaceURI(String prefix) {
	    //    System.out.println("getNamespaceURI(" + prefix + ")") ;
	    //    System.out.println("return=" + nsMap.get(prefix)) ;
		
		if (nsMap.containsKey(prefix)){
			String uri = nsMap.get(prefix);
			return uri;
		}
		
		return XMLConstants.NULL_NS_URI;
	}
	
	public String getPrefix(String uri) {
	    System.out.println("getPrefix("+uri+")"); 
	    /* <<< [[07/12/04 11:36 I.Noda]] <<< */
	    //throw new UnsupportedOperationException();
	    /* === [[07/12/04 11:36 I.Noda]] === */
	    return reverseMap.get(uri) ;
	    /* >>> [[07/12/04 11:36 I.Noda]] >>> */
	}
	
	public Iterator getPrefixes() {
		return getPrefixes(null);
	}

	public Iterator getPrefixes(String uri) {
		System.out.println("getPrefixS("+uri+")"); 
		throw new UnsupportedOperationException();		
	}
}
