package aist.daruma.client.darumaearth;

import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Node;
import javax.xml.namespace.NamespaceContext;

public class GmlCurve extends GmlGeometry {
	static final protected String tagName = "Curve";

	public String gmlTagName() {
		return tagName;
	}
	
	public String gmlTagFullName() {
		return GmlGeometry.tagPrefix+":"+tagName;
	}
	
	protected ArrayList<GmlPoint> pointList;
	
	public GmlCurve() {
		pointList = new ArrayList<GmlPoint>();
	}
	
	public ArrayList<GmlPoint> getPointList() {
		return pointList;
	}
	
	public boolean addPoint(GmlPoint point) {
		return this.pointList.add(point);
	}
	
	public int getPointListSize() {
		return pointList.size();
	}
		
	public GmlPoint getPointAt(int index) {
		if (pointList.size() <= index) {
			return null;
		}
			
		return pointList.get(index);
	}
	
	public Iterator iterator() {
		return getPointList().iterator();
	}
	
	protected void scanGmlBodyAndAddPoints(Node xmlNode, NamespaceContext nsContext,  Object crs) 
	    throws ScanGmlException, Exception {

		Node coordNode = XmlUtil.getNodeByXPath(xmlNode, coordNodeXPath, nsContext);
		if (coordNode == null) {
			throw new ScanGmlException(coordNodeXPath+" not matched.");
		}

		String gmlCoordStr = coordNode.getNodeValue();
		
		String[] pointStrList =  gmlCoordStr.split("[ \t\r\n]");

		for (int i=0; i < pointStrList.length; i++ ) {
			this.addPoint(GmlPoint.newPointForCoordinatesWithCRS(pointStrList[i], crs));
		}
	}
	
	static public GmlCurve scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object crs) 
	    throws Exception {
		GmlCurve curve = new GmlCurve();
		
		curve.scanGmlBodyAndAddPoints(xmlNode, nsContext, crs);
		
		return curve;
	}
}
