package aist.daruma.client.darumaearth;

import org.w3c.dom.Node;
import javax.xml.namespace.NamespaceContext;

public class GmlGeometry {
	static final protected String tagPrefix = "gml";
	static final protected String tagName = "Geometry";
	static final protected String tagFullName = tagPrefix+":"+tagName;
	
	static final protected String coordNodeXPath = "gml:coordinates/text()";
	static final protected String exteriorNodeXPath = "gml:exterior";
	static final protected String outerBoundaryIsNodeXPath = "gml:outerBoundaryIs";
	static final protected String interiorNodeXPath = "gml:interior";
	static final protected String innerBoundaryIsNodeXPath = "gml:innerBoundaryIs";
	
	public String gmlTagPrefix() {
		return tagPrefix;
	}

	public String gmlTagName() {
		return tagName;
	}
	
	public String gmlTagFullName() {
		return this.gmlTagPrefix()+":"+this.gmlTagName();
	}
	
	static public GmlGeometry scanGml(Node xmlNode, NamespaceContext nsContext, Object crs) 
	    throws ScanGmlException, Exception {
		//  'srsName' と云う Attributeをとりだして  CRSとする

		String crsStr = XmlUtil.getAttributeByName(xmlNode, "srsName");
		
		if (crsStr == null || crsStr.equals("")) {
			// CRS = defaultCRS;
		}

		String tagName = xmlNode.getLocalName();
		if ( tagName.equals("Point")) {
			return GmlPoint.scanGmlBody(xmlNode, nsContext, crs);
		} else if (tagName.equals("LineString")) {
			return GmlLineString.scanGmlBody(xmlNode, nsContext, crs);			
		} else if (tagName.equals("LinearRing")) {			
			return GmlLinearRing.scanGmlBody(xmlNode, nsContext, crs);			
		} else if (tagName.equals("Polygon")) {
			return GmlPolygon.scanGmlBody(xmlNode, nsContext, crs);			
		} else {
			//throw new ScanGmlException("Unsupported Node \""+ tagName+"\" encounterd.");
			System.out.println("GmlGeometry#scanGml: Unsupported node \""+ tagName+"\" encounterd.");
			// return Gmlxxx.scanGml(xmlNode, CRS);
		}
		return null;
	}
	
	
}
