package aist.daruma.client.darumaearth;

import org.w3c.dom.Node;
import javax.xml.namespace.NamespaceContext;

public class GmlPoint extends GmlGeometry {
	static final protected String tagName = "Point";

	public String gmlTagName() {
		return tagName;
	}
	
	
	private double x;
	private double y;
	private double z;
	private boolean hasZ = false;
	
	public GmlPoint() {
		this.x = 0.0;
		this.y = 0.0;
		this.z = Double.NaN;
		hasZ = false;
	}
	
	public GmlPoint(double x, double y) {
		setXY(x,y);
	}

	public GmlPoint(double x, double y, double z) {
		setXY(x,y);
		setZ(z);
	}

	public GmlPoint(GmlPoint point) {
		setXY(point.x,point.y);
		if (point.hasZ()) {
			setZ(point.z);
		}
	}
	
	public boolean hasZ() {
		return this.hasZ;
	}
	
	public void setXY(double x, double y) {
		this.x = x;
		this.y = y;
		this.z = 0.0;
		hasZ = false;
	}

	public void setXYZ(double x, double y, double z) {
		this.x = x;
		this.y = y;
		this.z = z;
		hasZ = true;
	}
	
	public void setZ(double z) {
		this.z = z;
		hasZ = true;
	}
	
	public double getX() {
		return this.x;
	}
	
	public double getY() {
		return this.y;
	}
	
	public double getZ() {
		return this.z;
	}
	
	
	static public GmlPoint scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object crs) 
	   throws ScanGmlException, Exception {
		Node coordNode = XmlUtil.getNodeByXPath(xmlNode, coordNodeXPath , nsContext);
		if (coordNode == null) {
			throw new ScanGmlException(coordNodeXPath+" not matched.");
		}
		String gmlCoordStr = coordNode.getNodeValue();
		return newPointForCoordinatesWithCRS(gmlCoordStr, crs);
	}
	
	static public GmlPoint newPointForCoordinatesWithCRS(String gmlCoordStr, Object crs) {
		String[] coordValues =  gmlCoordStr.split(",");
		
		double [] pointValues = GmlUtil.gmlCoodStrToSysValueWithCRS(gmlCoordStr, crs);
		
		double x = pointValues[0];
		double y = pointValues[1];

		if (coordValues.length >2) {
			// TODO: this is not same as ruby version... 
			double z = Double.parseDouble(coordValues[2]);
			return new GmlPoint(x,y,z);
		} else {
			return new GmlPoint(x,y);
		}
	}
}
