package aist.daruma.client.darumaearth;

import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.namespace.NamespaceContext;

public class GmlSurface extends GmlGeometry {
	static final protected String tagName = "Surface";

	public String gmlTagName() {
		return tagName;
	}
	
	protected GmlCurve exterior;
	protected ArrayList<GmlCurve> interior;
	
	public GmlSurface() {
		exterior = new GmlCurve();
		interior = new ArrayList<GmlCurve>();
	}

	public GmlSurface(GmlCurve exterior, ArrayList<GmlCurve> interior) {
		this.exterior = new GmlCurve();
		this.interior = new ArrayList<GmlCurve>();
		setGeometryList(exterior, interior);
	}
	
	public void setGeometryList(GmlCurve exterior, ArrayList<GmlCurve>interior) {
		clear();
		this.exterior = exterior;
		this.interior.addAll(interior);
	}

	public void clear() {
		this.exterior = null;
		this.interior.clear();
	}

	public void setExterior(GmlCurve exterior) {
		this.exterior = exterior;
	}
	
	public GmlCurve getExterior() {
		return this.exterior;
	}
	
	public void addInterior(GmlCurve geom) {
		this.interior.add(geom);
	}
	
	public void addInterior(ArrayList<GmlCurve> interior) {
		this.interior.addAll(interior);
	}

	public GmlGeometry getInteriorAt(int index) {
		return this.interior.get(index);
	}
	
	public int getInteriorSize() {
		return this.interior.size();
	}
	
	public Iterator getInteriorIterator() {
		return this.interior.iterator();
	}
	
	static public GmlSurface scanGmlBody(Node xmlNode, NamespaceContext nsContext, Object CRS) throws Exception {
		throw new UnsupportedOperationException();
		//return null;
	}
	
	protected void scanGmlBodyAndAddContents(Node xmlNode, NamespaceContext nsContext, Object CRS) 
	   throws ScanGmlException, Exception {
		clear();
		Node exteriorNode = null;
		exteriorNode = XmlUtil.getNodeByXPath(xmlNode, exteriorNodeXPath , nsContext);
		if (exteriorNode == null ) {
			exteriorNode = XmlUtil.getNodeByXPath(xmlNode, outerBoundaryIsNodeXPath, nsContext);
		}
		
		if (exteriorNode == null ) {
			throw new ScanGmlException("No Exterior Node.");
		}
		Node extGeoNode = XmlUtil.getNodeByXPath(exteriorNode, "*", nsContext); 
		
		this.setExterior((GmlCurve)GmlGeometry.scanGml(extGeoNode, nsContext, CRS));
		
		NodeList intNodeList = null;
		intNodeList = XmlUtil.getNodeListByXPath(xmlNode, interiorNodeXPath, nsContext);
		if (intNodeList != null) {
			for (int i = 0; i < intNodeList.getLength(); i++){
				Node n = intNodeList.item(i);
				if (n.getNodeType() == Node.ELEMENT_NODE) {
					this.addInterior((GmlCurve)GmlGeometry.scanGml(n,nsContext, CRS));
				}
			}
		}
		
		intNodeList = XmlUtil.getNodeListByXPath(xmlNode, innerBoundaryIsNodeXPath, nsContext);
		if (intNodeList != null) {
			for (int i = 0; i < intNodeList.getLength(); i++){
				Node n = intNodeList.item(i);
				if (n.getNodeType() == Node.ELEMENT_NODE) {
					this.addInterior((GmlCurve)GmlGeometry.scanGml(n,nsContext, CRS));
				}
			}
		}

	}
	
}
