package aist.daruma.client.darumaearth;

import java.util.HashMap;
import java.util.Iterator;

public class GmlUtil {
	static private GmlUtil gmlUtil = new GmlUtil();
	static public final double gmlVersion=2.0;

	private GmlUtil() {
		if (gmlVersion < 3.0 ) {
			tagName_exterior = "gml:outerBoundaryIs";
			tagName_interior = "gml:innerBoundaryIs";						
		} else {
			tagName_exterior = "gml:exterior";
			tagName_interior = "gml:interior";
		}
	}

	private String tagName_exterior;
	private String tagName_interior;
	
	static public GmlUtil getInstance() {
		return gmlUtil;
	}
	
	static public String tagName_exterior() {
		return gmlUtil.tagName_exterior;
	}
	static public String tagName_interior() {
		return gmlUtil.tagName_interior;
	}
	
	static public final String systemCRS = "#systemCRS";
	static public final String defaultCRS = systemCRS;
	
	static public final String systemTimeZone = "+09:00";
	static public final String defaultTimeZone = systemTimeZone;
	
	static public String xmlTaggedBlock(String tagLabel, String propStr, String bodyStr, boolean indent) {
		StringBuilder strbuf = new StringBuilder();		
		if (bodyStr == null || bodyStr.equals("")) {
			strbuf.append('<').append(tagLabel).append(propStr).append("/>");
		} else {
			strbuf.append('<').append(tagLabel).append(propStr).append(">");
			strbuf.append(bodyStr);
			strbuf.append("</").append(tagLabel).append('>');
		}
		
		return strbuf.toString();
	}
	
	static public String xmlTaggedBlock(String tagLabel, HashMap prop, String bodyStr, boolean indent) {

		String propStr = "";
		if (prop != null) {
			propStr = "";
			Iterator itSlot = prop.keySet().iterator();
			StringBuilder strbuf = new StringBuilder();
			while ( itSlot.hasNext()) {
				String slot = itSlot.next().toString();
				strbuf.append(' ');
				strbuf.append(slot);
				strbuf.append('=');
				strbuf.append(prop.get(slot));
			}
			propStr = strbuf.toString();
		}

		return xmlTaggedBlock(tagLabel, propStr, bodyStr, indent);
	}
	
	/**
	 * 
	 * @param posStr 座標文字列(カンマくぎり)
	 * @param CRS    座標参照系(クラス未定義)
	 * @return double の配列 x = [0], y = [1];
	 */
	static public double [] gmlCoodStrToSysValueWithCRS(String posStr, Object CRS) {
		String [] strs = posStr.split(",");
		double x = Double.parseDouble(strs[0]);
		double y = Double.parseDouble(strs[1]);		
		return coodGmlToSys(x, y, CRS);
	}
	
	static private double[] coodGmlToSys(double x, double y, Object crs) {
		return convertCRS(x, y, systemCRS, crs);
	}
	
	static private double[] coodSysToGml(double x, double y, Object crs) {
		return convertCRS(x, y, crs, systemCRS);
	}
	
	static private double[] convertCRS(double x, double y, Object fromCRS, Object toCRS) {
		//
		// TODO: should be implemented.
		//
		return new double[] {x,y};
	}
	
}