package aist.daruma.client.darumaearth;

import java.io.FileOutputStream;
import java.io.FileNotFoundException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MispRequestBuilder {
	private DarumaEarthConfig conf;
	private Document doc;

	public MispRequestBuilder() throws Exception {
		conf = DarumaEarthConfig.getConfig();
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);
		
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			doc = builder.newDocument();
		} catch (ParserConfigurationException pce ) {
			System.out.print("Internal error. can't get document builder...");
			System.out.println(pce.getMessage());
			throw pce;
		}
	}
	
	public Node wrapBySoapEnv(Node node) {
		Node soapenv = null;

		String soapNsURI = XmlUtil.getNameSpaceURL("soap");
		Element root = (Element) doc.createElementNS(soapNsURI, "SOAP-ENV:Envelope");
		root.appendChild(node);
		soapenv = root;

		return soapenv;
	}

	private Element setNameSpaceList(Element el, String[] nameSpaceList) {
		if (nameSpaceList == null) {
			return el;
		}
		
		String s;
		for (int i=0; i < nameSpaceList.length ; i++) {
			s = nameSpaceList[i];
			el.setAttribute( "xmlns:"+s, XmlUtil.getNameSpaceURL(s));
		}
		return el;
	}

	private Element setNameSpace(Element el, String prefix, String uri) {
		String ns = "xmlns";
		if (prefix != null && !prefix.equals("")) {
			ns += ":"+prefix;
		}

		if (uri != null && uri != "") {
			el.setAttribute( ns, uri);
		}
		
		return el;
	}
	
	/**
	 * 
	 * @param featureName
	 * @return
	 */
	public Node genGetFeature(String featureName, Node condNode, String prefixNs, String prefixUri) {
		Element featureNode = null;

		featureNode = doc.createElement("misp:GetFeature");
		featureNode = setNameSpaceList(featureNode,new String[]{"gml","xlink","misp"});

		featureNode = setNameSpace(featureNode, prefixNs, prefixUri);

		Element queryElement = doc.createElement("misp:Query");

		queryElement.setAttribute("mode", "features"); 	// TODO: mode は暫定的に固定
		queryElement.setAttribute("typeName", featureName);

		// XXX: temporary
		queryElement.setAttribute("srsName", "#la-la-port-dining");

		featureNode.appendChild(queryElement);
		Element filterElement = doc.createElement("misp:Filter");
		queryElement.appendChild(filterElement);

		if (condNode == null) {
			Element cond = doc.createElement("misp:True");
			filterElement.appendChild(cond);				
		} else {
			filterElement.appendChild(condNode);
		}
		
		return featureNode;
	}
	
	public void requestToFile(String filename, Node requestNode) throws FileNotFoundException {
		Node soap = wrapBySoapEnv(requestNode);

		FileOutputStream reqFileStream = new FileOutputStream(filename);
		XmlUtil.domToStream(soap, reqFileStream);
	}
	
	public void genGetFeatureRequestToFile(String filename, String featureName,String prefixNs, String prefixUri ) 
	    throws FileNotFoundException {
		Node requestNode = genGetFeature(featureName, null, prefixNs, prefixUri);
		requestToFile(filename, requestNode);
	}
	
	public Node genGetFeatureGetImageData(String featureName, String imageId, String idPath, String prefixNs, String prefixUri) {
		Node propNode = doc.createElement("misp:PropertyName");
		propNode.setTextContent(idPath);
		
		Node litNode = doc.createElement("misp:Literal");
		litNode.setTextContent(imageId);

		Node condNode = doc.createElement("misp:PropertyIsEqualTo");
		condNode.appendChild(propNode);
		condNode.appendChild(litNode);
		
		return genGetFeature(featureName,condNode, prefixNs, prefixUri);
	}
	/**
	 *  テスト用
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			MispRequestBuilder builder = new MispRequestBuilder();
			Node requestNode = builder.genGetFeature("AlertInformation", null, null, null);
			Node soap = builder.wrapBySoapEnv(requestNode);
			XmlUtil.domToStream(soap, System.out);


			Node requestImageNode = builder.genGetFeatureGetImageData("sensedDataEntity","http://someware/some.img","./@gml:id", null, null);
			Node imageSoap = builder.wrapBySoapEnv(requestImageNode);
			XmlUtil.domToStream(imageSoap, System.out);
		} catch (Exception e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		
	}
}
