package aist.daruma.client.darumaearth;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

/**
 * darumaServerと通信する
 * @author santa
 *
 */
public class MispSOAPClient {
	private DarumaEarthConfig conf;

	public MispSOAPClient() {
		conf = DarumaEarthConfig.getConfig();
	}
	
	
	static final long XFER_SIZE = 1024*1024;
	
	public void sendRequest(String host, int port,
			FileInputStream request, FileOutputStream response) throws IOException {

		if (conf.debug()) {
			System.out.println("MispSOAPClient#sendRequest() -- enter");
		}


		SocketAddress address = new InetSocketAddress(host, port);
		SocketChannel serverSc = SocketChannel.open(address);
		serverSc.configureBlocking(true);


		FileChannel requestFc = request.getChannel();
		FileChannel responseFc = response.getChannel();

		long size = requestFc.size();
		long sizeXfer;
		long pos = 0;
		do { 
			sizeXfer = requestFc.transferTo(pos, size, serverSc);
			pos += sizeXfer;
			size -= sizeXfer;
		} while (size > 0);

		requestFc.close();

		size = XFER_SIZE;
		pos = 0;
		do { 
			sizeXfer = responseFc.transferFrom(serverSc, pos, XFER_SIZE);
			pos += sizeXfer;
		} while (sizeXfer > 0);
		responseFc.close();
		serverSc.finishConnect();
		serverSc.close();


//		ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);

//		FileChannel requestFc = request.getChannel();
//		FileChannel responseFc = response.getChannel();

//		while ((requestFc.read(buffer)) != -1) {
//		buffer.flip();
//		serverSc.write(buffer);
//		buffer.clear();
//		}
//		requestFc.close();
//		buffer.clear();

//		while ((serverSc.read(buffer)) > 0) {
//		buffer.flip();
//		responseFc.write(buffer);
//		buffer.clear();
//		}

//		responseFc.close();
//		serverSc.finishConnect();
//		serverSc.close();


		if (conf.debug()) {
			System.out.println("MispSOAPClient#sendRequest() -- end");
		}

	}
}
