package daruma.global_switch;

import daruma.util.PropertyReader;
import daruma.util.FatalException;

public class ImplementationSwitches
{
    //
    // geometry conversion
    //
    private static final String ENABLE_GEOMETRY_CONVERSION_PROPERTY
				= "daruma.geometry.enable_conversion";
    private static final boolean ENABLE_GEOMETRY_CONVERSION_DEFAULT
				 = true;
    private boolean enableGeometryConversion;


    //
    // backend database type
    //
    public enum BackendDBType { PostGIS, MySQL };
    private String BACKEND_DB_TYPE_PROPERTY = "daruma.db.backend";
    private static final String BACKEND_DB_TYPE_DEFAULT = "MySQL";
    private BackendDBType backendDBType;

    public ImplementationSwitches() throws FatalException
    {
	this.enableGeometryConversion
	    = PropertyReader.getProperty
	      ( ENABLE_GEOMETRY_CONVERSION_PROPERTY,
		ENABLE_GEOMETRY_CONVERSION_DEFAULT );

	String backendDBTypeString 
	    = PropertyReader.getProperty
	      ( BACKEND_DB_TYPE_PROPERTY,
		BACKEND_DB_TYPE_DEFAULT );

	if ( backendDBTypeString.equals( "PostGIS" ) )
	{
	    backendDBType = BackendDBType.PostGIS;
	}
	else if ( backendDBTypeString.equals( "MySQL" ) )
	{
	    backendDBType = BackendDBType.MySQL;
	}
	else
	{
	    throw new FatalException
		( "invalid property value of ["
		  + BACKEND_DB_TYPE_PROPERTY + "],"
		  + " value = [" + this.backendDBType + "],"
		  + " expected was [PostGIS] or [MySQL]." );
	}
    }

    public boolean getEnableGeometryConversion()
    {
	return enableGeometryConversion;
    }


    public BackendDBType getBackendDBType()
    {
	return backendDBType;
    }

    public boolean isPostGISBackend()
    {
	return backendDBType == BackendDBType.PostGIS;
    }

    public boolean isMySQLBackend()
    {
	return backendDBType == BackendDBType.MySQL;
    }


    //
    // singleton
    //
    private static ImplementationSwitches obj = null;

    public static void createInstance() throws FatalException
    {
	if ( obj == null )
	{
	    obj = new ImplementationSwitches();
	}
    }

    public static ImplementationSwitches instance()
    {
	return obj;
    }
}
