package daruma.sql;

import daruma.global_switch.ImplementationSwitches;
import daruma.sql.SQLDataType;
import java.sql.Timestamp;

public class SQLDataTypeConstant
{
    public static SQLDataType BLOB;

    static
    {
	if ( ImplementationSwitches.instance().isMySQLBackend() )
	{
	    BLOB = new SQLDataType( "longblob", String.class );
	}
	else
	{
	    BLOB = new SQLDataType( "text", String.class );
	}
    }

    public static final SQLDataType DOUBLE
			= new SQLDataType( "double precision", Double.class );

    public static final SQLDataType FLOAT
			 = new SQLDataType( "float", Float.class );

    public static final SQLDataType TIMESTAMP
			 = new SQLDataType( "timestamp", Timestamp.class );
}
