/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import daruma.geometry.DrmBox;
import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmLineString;
import daruma.geometry.DrmLinearRing;
import daruma.geometry.DrmMultiPoint;
import daruma.geometry.DrmPoint;
import daruma.geometry.DrmPolygon;
import daruma.geometry.GeometryException;
import daruma.storage_manager.type_definition.ElementName;
import daruma.util.LogWriter;
import daruma.xml.URI;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLParseErrorException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeometryFormatConverter {
    private GeometryFormatConverter() {
    }

    public static DrmPoint parseGMLPoint(String coordinatesString) throws GeometryException {
        double z;
        double y;
        double x;
        String[] values = coordinatesString.trim().split(",");
        if (values.length < 2) {
            throw new GeometryException("expected at least 2 values: \"" + coordinatesString + "\"");
        }
        try {
            x = Double.parseDouble(values[0]);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("\"" + values[0] + "\"" + " is not a valid number");
        }
        try {
            y = Double.parseDouble(values[1]);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("\"" + values[1] + "\"" + " is not a valid number");
        }
        if (values.length <= 2) {
            return new DrmPoint(x, y);
        }
        try {
            z = Double.parseDouble(values[2]);
        }
        catch (NumberFormatException e) {
            throw new GeometryException("\"" + values[2] + "\"" + " is not a valid number");
        }
        return new DrmPoint(x, y, z);
    }

    public static DrmLineString parseGMLLineString(String coordinatesString) throws GeometryException {
        String[] points;
        DrmLineString ret = new DrmLineString();
        for (String pointString : points = coordinatesString.trim().split("[ \t\n\r]+")) {
            ret.add(GeometryFormatConverter.parseGMLPoint(pointString));
        }
        return ret;
    }

    private static List<DrmPoint> parseCoordinatesElement(Element coordinatesElement) throws GeometryException {
        String[] points;
        ArrayList<DrmPoint> ret = new ArrayList<DrmPoint>();
        if (coordinatesElement.getNamespaceURI() == null || !coordinatesElement.getNamespaceURI().equals(URI.GML) || !coordinatesElement.getLocalName().equals("coordinates")) {
            throw new GeometryException("unexpected element \"" + coordinatesElement.getLocalName() + "\" in namespace " + coordinatesElement.getNamespaceURI() + ", expexted was " + "\"coordinates\" element in namespace " + URI.GML);
        }
        String coordinatesString = ElementUtil.getChildNodesWholeText(coordinatesElement);
        for (String pointString : points = coordinatesString.trim().split("[ \t\n\r]+")) {
            ret.add(GeometryFormatConverter.parseGMLPoint(pointString));
        }
        return ret;
    }

    public static DrmPolygon parseGMLBox(String coordinatesString) throws GeometryException {
        String[] points = coordinatesString.trim().split("[ \t\n\r]+");
        ArrayList<DrmPoint> pointList = new ArrayList<DrmPoint>();
        for (String pointString : points) {
            pointList.add(GeometryFormatConverter.parseGMLPoint(pointString));
        }
        if (pointList.size() != 2) {
            throw new GeometryException("invalid Box format, 2 points expected");
        }
        DrmPoint pMin = (DrmPoint)pointList.get(0);
        DrmPoint pMax = (DrmPoint)pointList.get(1);
        return new DrmBox(pMin, pMax);
    }

    public static String convertGeometryToWKTString(DrmGeometry geom, boolean dropTo2D, boolean convertEmptyGeometryToNull) {
        if (geom instanceof DrmPoint) {
            return GeometryFormatConverter.convertPointToWKTString((DrmPoint)geom, dropTo2D);
        }
        if (geom instanceof DrmLineString) {
            return GeometryFormatConverter.convertLineStringToWKTString((DrmLineString)geom, dropTo2D);
        }
        if (geom instanceof DrmPolygon) {
            return GeometryFormatConverter.convertPolygonToWKTString((DrmPolygon)geom, dropTo2D);
        }
        if (geom instanceof DrmMultiPoint) {
            return GeometryFormatConverter.convertMultiPointToWKTString((DrmMultiPoint)geom, dropTo2D, convertEmptyGeometryToNull);
        }
        return null;
    }

    public static String convertCoordinatesToWKTString(List<DrmPoint> points, boolean dropTo2D) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        boolean firstPoint = true;
        for (DrmPoint p : points) {
            if (!firstPoint) {
                buf.append(",");
            }
            buf.append(p.getX());
            buf.append(" ");
            buf.append(p.getY());
            if (!dropTo2D && p.getDimension() >= 3) {
                buf.append(" ");
                buf.append(p.getZ());
            }
            firstPoint = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String convertPointToWKTString(DrmPoint point, boolean dropTo2D) {
        StringBuffer buf = new StringBuffer();
        buf.append("POINT(");
        buf.append(point.getX());
        buf.append(" ");
        buf.append(point.getY());
        if (!dropTo2D && point.getDimension() >= 3) {
            buf.append(" ");
            buf.append(point.getZ());
        }
        buf.append(")");
        return buf.toString();
    }

    public static String convertLineStringToWKTString(DrmLineString lineString, boolean dropTo2D) {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING");
        buf.append(GeometryFormatConverter.convertCoordinatesToWKTString(lineString.getPoints(), dropTo2D));
        return buf.toString();
    }

    public static String convertPolygonToWKTString(DrmPolygon polygon, boolean dropTo2D) {
        StringBuffer buf = new StringBuffer();
        buf.append("POLYGON(");
        buf.append(GeometryFormatConverter.convertCoordinatesToWKTString(polygon.getOuterBoundary().getPoints(), dropTo2D));
        for (DrmLinearRing r : polygon.getInnerBoundaries()) {
            buf.append(",");
            buf.append(GeometryFormatConverter.convertCoordinatesToWKTString(r.getPoints(), dropTo2D));
        }
        buf.append(")");
        return buf.toString();
    }

    public static String convertMultiPointToWKTString(DrmMultiPoint multiPoint, boolean dropTo2D, boolean convertEmptyGeometryToNull) {
        if (multiPoint.getPoints().isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("MULTIPOINT(");
        boolean firstPoint = true;
        for (DrmPoint point : multiPoint.getPoints()) {
            if (!firstPoint) {
                buf.append(",");
            }
            buf.append(point.getX());
            buf.append(" ");
            buf.append(point.getY());
            if (!dropTo2D && point.getDimension() >= 3) {
                buf.append(" ");
                buf.append(point.getZ());
            }
            firstPoint = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String convertCoordinateToGMLString(DrmPoint point) {
        StringBuffer buf = new StringBuffer();
        buf.append(point.getX());
        buf.append(",");
        buf.append(point.getY());
        if (point.getDimension() >= 3) {
            buf.append(",");
            buf.append(point.getZ());
        }
        return buf.toString();
    }

    public static String convertCoordinatesToGMLString(List<DrmPoint> points) {
        StringBuffer buf = new StringBuffer();
        boolean firstPoint = true;
        for (DrmPoint p : points) {
            if (!firstPoint) {
                buf.append(" ");
            }
            buf.append(GeometryFormatConverter.convertCoordinateToGMLString(p));
            firstPoint = false;
        }
        return buf.toString();
    }

    public static DrmGeometry parseFromGMLElement(Element geometryElement) throws GeometryException {
        DrmGeometry geom;
        block14: {
            ElementName geometryTypeElementName = new ElementName(geometryElement);
            if (geometryElement.getNamespaceURI() == null || !geometryElement.getNamespaceURI().equals(URI.GML)) {
                throw new GeometryException("unexpected geometry type \"" + geometryTypeElementName + "\"");
            }
            Element childElement = null;
            if (!(geometryTypeElementName.getLocalName().equals("Polygon") || geometryTypeElementName.getLocalName().equals("MultiPolygon") || geometryTypeElementName.getLocalName().equals("MultiLineString") || geometryTypeElementName.getLocalName().equals("MultiPoint"))) {
                try {
                    childElement = ElementUtil.getSingleChildElement(geometryElement);
                }
                catch (XMLParseErrorException e) {
                    throw new GeometryException(e.getMessage(), e);
                }
            }
            if (geometryTypeElementName.getLocalName().equals("Point")) {
                String coordinatesString = GeometryFormatConverter.getCoordinatesString(childElement);
                geom = GeometryFormatConverter.parseGMLPoint(coordinatesString);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("LineString")) {
                String coordinatesString = GeometryFormatConverter.getCoordinatesString(childElement);
                geom = GeometryFormatConverter.parseGMLLineString(coordinatesString);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("Polygon")) {
                geom = GeometryFormatConverter.parseGMLPolygonElement(geometryElement);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("MultiPolygon")) {
                geom = GeometryFormatConverter.parseGMLMultiPolygonElement(geometryElement);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("MultiLineString")) {
                geom = new DrmPoint(0.0, 0.0);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("MultiPoint")) {
                geom = GeometryFormatConverter.parseGMLMultiPointElement(geometryElement);
                break block14;
            }
            if (geometryTypeElementName.getLocalName().equals("Box")) {
                String coordinatesString = GeometryFormatConverter.getCoordinatesString(childElement);
                geom = GeometryFormatConverter.parseGMLBox(coordinatesString);
                break block14;
            }
            throw new GeometryException("unexpected geometry type \"" + geometryTypeElementName + "\"");
        }
        if (geometryElement.hasAttributeNS(null, "srsName")) {
            geom.setSrsName(geometryElement.getAttributeNS(null, "srsName"));
        }
        return geom;
    }

    private static String getCoordinatesString(Element element) throws GeometryException {
        if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(URI.GML) || !element.getLocalName().equals("coordinates")) {
            throw new GeometryException("unexpected element \"" + element.getLocalName() + "\" in namespace " + element.getNamespaceURI() + ", expexted was " + "\"coordinates\" element in namespace " + URI.GML);
        }
        return ElementUtil.getChildNodesWholeText(element);
    }

    private static String getPolygonCoordinatesString(Element linearRingElement) throws GeometryException {
        Element coordinatesElement;
        try {
            if (linearRingElement.getNamespaceURI() == null || !linearRingElement.getNamespaceURI().equals(URI.GML) || !linearRingElement.getLocalName().equals("LinearRing")) {
                throw new GeometryException("unexpected element \"" + linearRingElement.getLocalName() + "\" in namespace " + linearRingElement.getNamespaceURI() + ", expexted was " + "\"LinearRing\" element in namespace " + URI.GML);
            }
            coordinatesElement = ElementUtil.getSingleChildElement(linearRingElement);
        }
        catch (XMLParseErrorException e) {
            throw new GeometryException(e.getMessage(), e);
        }
        if (coordinatesElement.getNamespaceURI() == null || !coordinatesElement.getNamespaceURI().equals(URI.GML) || !coordinatesElement.getLocalName().equals("coordinates")) {
            throw new GeometryException("unexpected element \"" + linearRingElement.getLocalName() + "\" in namespace " + linearRingElement.getNamespaceURI() + ", expexted was " + "\"coordinates\" element in namespace " + URI.GML);
        }
        return ElementUtil.getChildNodesWholeText(coordinatesElement);
    }

    private static DrmLinearRing parseGMLLinearRingElement(Element element) throws GeometryException {
        Element coordinatesElement;
        try {
            Element linearRingElement = ElementUtil.getSingleChildElement(element);
            LogWriter.qwrite("DEBUG", "linearRingElement = ", linearRingElement.getLocalName());
            if (linearRingElement.getNamespaceURI() == null || !linearRingElement.getNamespaceURI().equals(URI.GML) || !linearRingElement.getLocalName().equals("LinearRing")) {
                throw new GeometryException("unexpected element \"" + linearRingElement.getLocalName() + "\" in namespace " + linearRingElement.getNamespaceURI() + ", expexted was " + "\"LinearRing\" element in namespace " + URI.GML);
            }
            coordinatesElement = ElementUtil.getSingleChildElement(linearRingElement);
        }
        catch (XMLParseErrorException e) {
            throw new GeometryException(e.getMessage(), e);
        }
        List<DrmPoint> points = GeometryFormatConverter.parseCoordinatesElement(coordinatesElement);
        if (points.size() == 0) {
            throw new GeometryException("invalid LinearRing format, no points");
        }
        return new DrmLinearRing(points);
    }

    private static DrmPolygon parseGMLPolygonElement(Element polygonElement) throws GeometryException {
        if (polygonElement.getNamespaceURI() == null || !polygonElement.getNamespaceURI().equals(URI.GML) || !polygonElement.getLocalName().equals("Polygon")) {
            throw new GeometryException("unexpected element \"" + polygonElement.getLocalName() + "\" in namespace " + polygonElement.getNamespaceURI() + ", expexted was " + "\"Polygon\" element in namespace " + URI.GML);
        }
        List<Element> childElements = ElementUtil.getChildElements(polygonElement);
        if (childElements.size() == 0) {
            throw new GeometryException("too few child elements of \"" + polygonElement.getLocalName() + "\" in namespace " + polygonElement.getNamespaceURI());
        }
        Element outerBoundaryIsElement = childElements.get(0);
        if (outerBoundaryIsElement.getNamespaceURI() == null || !outerBoundaryIsElement.getNamespaceURI().equals(URI.GML) || !outerBoundaryIsElement.getLocalName().equals("outerBoundaryIs")) {
            throw new GeometryException("unexpected element \"" + outerBoundaryIsElement.getLocalName() + "\" in namespace " + outerBoundaryIsElement.getNamespaceURI() + ", expexted was " + "\"outerBoundaryIs\" element in namespace " + URI.GML);
        }
        try {
            Element outerBoundaryLinearRingElement = ElementUtil.getSingleChildElement(outerBoundaryIsElement);
        }
        catch (XMLParseErrorException e) {
            throw new GeometryException(e.getMessage(), e);
        }
        DrmLinearRing outerBoundary = GeometryFormatConverter.parseGMLLinearRingElement(outerBoundaryIsElement);
        if (!outerBoundary.closed()) {
            throw new GeometryException("invalid Polygon format,unclosed Polygon outer boundary");
        }
        DrmPolygon ret = new DrmPolygon(outerBoundary);
        for (int i = 1; i < childElements.size(); ++i) {
            Element innerBoundaryIsElement = childElements.get(i);
            if (innerBoundaryIsElement.getNamespaceURI() == null || !innerBoundaryIsElement.getNamespaceURI().equals(URI.GML) || !innerBoundaryIsElement.getLocalName().equals("innerBoundaryIs")) {
                throw new GeometryException("unexpected child elements of \"" + polygonElement.getLocalName() + "\" in namespace " + polygonElement.getNamespaceURI());
            }
            DrmLinearRing innerBoundary = GeometryFormatConverter.parseGMLLinearRingElement(innerBoundaryIsElement);
            if (!innerBoundary.closed()) {
                throw new GeometryException("invalid Polygon format,unclosed Polygon inner boundary");
            }
            ret.addInnerBoundary(innerBoundary);
        }
        return ret;
    }

    private static DrmGeometry parseGMLMultiPolygonElement(Element multiPolygonElement) throws GeometryException {
        if (multiPolygonElement.getNamespaceURI() == null || !multiPolygonElement.getNamespaceURI().equals(URI.GML) || !multiPolygonElement.getLocalName().equals("MultiPolygon")) {
            throw new GeometryException("unexpected element \"" + multiPolygonElement.getLocalName() + "\" in namespace " + multiPolygonElement.getNamespaceURI() + ", expexted was " + "\"MultiPolygon\" element in namespace " + URI.GML);
        }
        return new DrmPoint(0.0, 0.0);
    }

    public static DrmPoint parseGMLPointElement(Element pointElement) throws GeometryException {
        Element coordinatesElement;
        if (pointElement.getNamespaceURI() == null || !pointElement.getNamespaceURI().equals(URI.GML) || !pointElement.getLocalName().equals("Point")) {
            throw new GeometryException("unexpected element \"" + pointElement.getLocalName() + "\" in namespace " + pointElement.getNamespaceURI() + ", expexted was " + "\"Point\" element in namespace " + URI.GML);
        }
        try {
            coordinatesElement = ElementUtil.getSingleChildElement(pointElement);
        }
        catch (XMLParseErrorException e) {
            throw new GeometryException(e.getMessage(), e);
        }
        String coordinatesString = GeometryFormatConverter.getCoordinatesString(coordinatesElement);
        return GeometryFormatConverter.parseGMLPoint(coordinatesString);
    }

    public static DrmMultiPoint parseGMLMultiPointElement(Element multiPointElement) throws GeometryException {
        if (multiPointElement.getNamespaceURI() == null || !multiPointElement.getNamespaceURI().equals(URI.GML) || !multiPointElement.getLocalName().equals("MultiPoint")) {
            throw new GeometryException("unexpected element \"" + multiPointElement.getLocalName() + "\" in namespace " + multiPointElement.getNamespaceURI() + ", expexted was " + "\"MultiPoint\" element in namespace " + URI.GML);
        }
        List<Element> childElements = ElementUtil.getChildElements(multiPointElement);
        DrmMultiPoint ret = new DrmMultiPoint();
        for (Element pointMemberElement : childElements) {
            Element pointElement;
            if (pointMemberElement.getNamespaceURI() == null || !pointMemberElement.getNamespaceURI().equals(URI.GML) || !pointMemberElement.getLocalName().equals("pointMember")) {
                throw new GeometryException("unexpected element \"" + pointMemberElement.getLocalName() + "\" in namespace " + pointMemberElement.getNamespaceURI() + ", expexted was " + "\"pointMember\" element in namespace " + URI.GML);
            }
            try {
                pointElement = ElementUtil.getSingleChildElement(pointMemberElement);
            }
            catch (XMLParseErrorException e) {
                throw new GeometryException(e.getMessage(), e);
            }
            ret.add(GeometryFormatConverter.parseGMLPointElement(pointElement));
        }
        return ret;
    }

    public static Element convertToGMLElement(Document doc, DrmGeometry geom) throws GeometryException {
        Element g = null;
        if (geom instanceof DrmPoint) {
            DrmPoint c = (DrmPoint)geom;
            g = doc.createElementNS(URI.GML, "Point");
            Element coordinatesElement = doc.createElementNS(URI.GML, "coordinates");
            g.appendChild(coordinatesElement);
            String coordinates = GeometryFormatConverter.convertCoordinateToGMLString(c);
            coordinatesElement.appendChild(doc.createTextNode(coordinates));
        } else if (geom instanceof DrmBox) {
            DrmBox c = (DrmBox)geom;
            g = doc.createElementNS(URI.GML, "Box");
            Element coordinatesElement = doc.createElementNS(URI.GML, "coordinates");
            g.appendChild(coordinatesElement);
            String coordinates = Double.toString(c.getMinX()) + "," + Double.toString(c.getMinY()) + " " + Double.toString(c.getMaxX()) + "," + Double.toString(c.getMaxY());
            coordinatesElement.appendChild(doc.createTextNode(coordinates));
        } else if (geom instanceof DrmLineString) {
            DrmLineString c = (DrmLineString)geom;
            g = doc.createElementNS(URI.GML, "LineString");
            Element coordinatesElement = doc.createElementNS(URI.GML, "coordinates");
            g.appendChild(coordinatesElement);
            String coordinates = GeometryFormatConverter.convertCoordinatesToGMLString(c.getPoints());
            coordinatesElement.appendChild(doc.createTextNode(coordinates));
        } else if (geom instanceof DrmPolygon) {
            DrmPolygon c = (DrmPolygon)geom;
            g = doc.createElementNS(URI.GML, "Polygon");
            Element outerBoundaryIsElement = doc.createElementNS(URI.GML, "outerBoundaryIs");
            g.appendChild(outerBoundaryIsElement);
            Element linearRingElement = doc.createElementNS(URI.GML, "LinearRing");
            outerBoundaryIsElement.appendChild(linearRingElement);
            Element coordinatesElement = doc.createElementNS(URI.GML, "coordinates");
            linearRingElement.appendChild(coordinatesElement);
            String coordinates = GeometryFormatConverter.convertCoordinatesToGMLString(c.getOuterBoundary().getPoints());
            coordinatesElement.appendChild(doc.createTextNode(coordinates));
        } else if (geom instanceof DrmMultiPoint) {
            DrmMultiPoint mp = (DrmMultiPoint)geom;
            g = doc.createElementNS(URI.GML, "MultiPoint");
            for (DrmPoint p : mp.getPoints()) {
                Element pointMemberElement = doc.createElementNS(URI.GML, "pointMember");
                g.appendChild(pointMemberElement);
                pointMemberElement.appendChild(GeometryFormatConverter.convertToGMLElement(doc, p));
            }
        } else {
            throw new GeometryException("internal error: unexpected geometry type");
        }
        if (geom.getSrsName() != null) {
            g.setAttributeNS(null, "srsName", geom.getSrsName());
        }
        return g;
    }
}

