/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.server.DarumaDaemon;
import daruma.util.Itk;
import daruma.util.LogWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class DarumaDaemonAdministrator
implements Runnable {
    private final DarumaDaemon daemon;
    private final int adminPort;

    DarumaDaemonAdministrator(DarumaDaemon daemon, int adminPort) {
        this.daemon = daemon;
        this.adminPort = adminPort;
    }

    @Override
    public void run() {
        try {
            ServerSocket adminSocket = new ServerSocket(this.adminPort);
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Listen:", adminSocket);
            while (true) {
                Socket s = adminSocket.accept();
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Open :", s);
                String command = "forceDisconectClient";
                try {
                    if ("forceDisconectClient".equals("forceDisconectClient")) {
                        this.forceDisconectClient();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Close :", s);
                    s.close();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDisconectClient() throws IOException {
        Object object = this.daemon.adminLock;
        synchronized (object) {
            if (this.daemon.admin.currentClientSocket != null) {
                LogWriter.qwrite("INFO", "closing client Socket: ", this.daemon.admin.currentClientSocket);
                this.daemon.admin.currentClientSocket.close();
            }
        }
    }
}

