/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.schema;

import daruma.xml.NameSpace;
import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.XMLFormatConverter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSchemaSet {
    private List<Entry> list = new ArrayList<Entry>();

    public Entry add(String schemaStr) {
        Entry entry = new Entry(schemaStr);
        Entry oldEntry = this.getEntryByID(entry.getID());
        if (oldEntry == null) {
            this.list.add(entry);
            return entry;
        }
        return null;
    }

    public Entry getEntryByID(String uri) {
        for (Entry entry : this.list) {
            if (!entry.getID().equals(uri)) continue;
            return entry;
        }
        return null;
    }

    public List<Entry> getList() {
        return this.list;
    }

    public long size() {
        return this.list.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private String id = null;
        private String targetNameSpace;
        private String string = null;
        private Element element = null;
        private List<String> importList = new ArrayList<String>();

        public Entry(String string) {
            this.set(string, true);
        }

        public Entry set(String string, boolean scanp) {
            this.setString(string);
            if (scanp) {
                this.scanString();
            }
            return this;
        }

        public Entry set(String string) {
            return this.set(string, true);
        }

        public Entry scanString() {
            try {
                Document doc = DOMDocumentFactory.create();
                XMLFormatConverter.readNode(new StringReader(this.string), (Node)doc);
                this.element = doc.getDocumentElement();
                this.setIDTargetNSByElement();
                this.checkImport();
                return this;
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public String setIDTargetNSByElement() {
            try {
                Attr nsAttr;
                Attr idAttr = (Attr)XPathAPI.selectSingleNode((Node)this.element, (String)"@misp:id", (Node)NameSpace.DefaultContext);
                if (idAttr != null) {
                    this.setID(idAttr.getValue());
                }
                if ((nsAttr = (Attr)XPathAPI.selectSingleNode((Node)this.element, (String)"@targetNamespace", (Node)NameSpace.DefaultContext)) != null) {
                    this.setTargetNameSpace(nsAttr.getValue());
                }
                return this.getID();
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void checkImport() throws TransformerException {
            NodeIterator nodes = XPathAPI.selectNodeIterator((Node)this.element, (String)"//xsd:import/@namespace", (Node)NameSpace.DefaultContext);
            Node node = null;
            while ((node = nodes.nextNode()) != null) {
                String nsURI = ((Attr)node).getValue();
                this.importList.add(nsURI);
            }
        }

        public List<String> getImportList() {
            return this.importList;
        }

        public String getID() {
            return this.id;
        }

        public String setID(String id) {
            this.id = id;
            return this.id;
        }

        public String getTargetNameSpace() {
            return this.targetNameSpace;
        }

        public String setTargetNameSpace(String nsURI) {
            this.targetNameSpace = nsURI;
            return this.targetNameSpace;
        }

        public String getString() {
            try {
                if (this.string == null && this.element != null) {
                    this.string = XMLFormatConverter.toString(this.element, false);
                }
                return this.string;
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public String setString(String string) {
            this.string = string;
            return this.string;
        }
    }
}

