/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.util;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeUtil {
    private NodeUtil() {
    }

    public static String lookupNamespaceURI(Node node, String prefix) {
        if (node.getPrefix() != null && node.getPrefix().equals(prefix)) {
            return node.getNamespaceURI();
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String pref = attr.getPrefix();
            if (!(prefix == null ? pref == null && attr.getLocalName().equals("xmlns") : pref != null && pref.equals("xmlns") && prefix.equals(attr.getLocalName()))) continue;
            return attr.getValue();
        }
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            return NodeUtil.lookupNamespaceURI(parentNode, prefix);
        }
        return null;
    }
}

