package daruma.sql;

import daruma.sql.DatabaseConnection;

public class MySQLDatabaseConnection extends DatabaseConnection
{
    public static final String MYSQL_DEFAULT_HOST = "localhost";
    public static final int MYSQL_DEFAULT_PORT = 3306;

    private String mysqlHost;
    private int mysqlPort;

    public MySQLDatabaseConnection( String mysqlHost, int mysqlPort )
    {
        this.mysqlHost = mysqlHost;
        this.mysqlPort = mysqlPort;
    }

    public MySQLDatabaseConnection()
    {
        this( MYSQL_DEFAULT_HOST, MYSQL_DEFAULT_PORT );
    }


    @Override
    protected String getDatabaseURIPrefix()
    {
        return "jdbc:mysql://" + this.mysqlHost + ":" + this.mysqlPort + "/";
    }

    @Override
    protected String getDatabaseURIPostfix()
    {
        return "?useUnicode=true"
               + "&characterEncoding=UTF-8"
               + "&autoReconnect=true";
//             + "&useCursorFetch=true"
    }

    @Override
    protected void connectHook() throws DatabaseConnectionException
    {
    }
}
