package daruma.sql;

import daruma.sql.DatabaseConnectionFactory;
import daruma.sql.MySQLDatabaseConnection;

public class MySQLDatabaseConnectionFactory extends DatabaseConnectionFactory
{
    private boolean useDefaultHostPort;
    private String mysqlHost;
    private int mysqlPort;

    public MySQLDatabaseConnectionFactory( String mysqlHost, int mysqlPort )
	throws DatabaseConnectionException
    {
	this.useDefaultHostPort = false;

	this.mysqlHost = mysqlHost;
	this.mysqlPort = mysqlPort;

	super.loadClass();
    }

    public MySQLDatabaseConnectionFactory()
	throws DatabaseConnectionException
    {
	this.useDefaultHostPort = true;

	super.loadClass();
    }


    @Override
    public String getDriverClass()
    {
	return "com.mysql.jdbc.Driver";
    }


    @Override
    public DatabaseConnection create()
    {
	if ( this.useDefaultHostPort )
	{
	    return new MySQLDatabaseConnection();
	}
	else
	{
	    return new MySQLDatabaseConnection( this.mysqlHost, this.mysqlPort );
	}
    }
}
