package daruma.storage_manager.type_definition.types;

import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;

import daruma.xml.util.WhitespaceProceccer;


public class FloatTypeDefinition extends AbstractSingleTypeDefinition
{
	public	FloatTypeDefinition()
	{
		super();
	}

	@Override
	public	SQLDataType	getSingleSQLDataType()
	{
		return( SQLDataTypeConstant.FLOAT );
	}

	@Override
	public	String	parseValue( String  value ) throws TypeException
	{
		String	v = WhitespaceProceccer.cutoffEdgeWhitespaces( value );

		try
		{
			Float.parseFloat( v );
		}
		catch( NumberFormatException  e )
		{
			throw new TypeException
			  ( "\"" + value + "\" is not a valid float value" );
		}

		return( v );
	}
}
