package daruma.util;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import daruma.util.PropertyReader;
import java.io.InputStream;
import java.net.URL;
import org.w3c.dom.Element;
import daruma.xml.util.XMLFormatConverter;
import javax.xml.transform.TransformerException;

import daruma.util.Itk;


/**
 * Ϥ륯饹<BR>
 * ϤˤJakartaץȤLog4jѤޤ<BR>
 * ٥롢衢ϥե礭
 * ե(daruma.properties)Ǵޤ<BR>
 * ʤեꤷ٥㤤٥ΥϽϤޤ<BR>
 */
public class LogWriter {

	// logger̾
	private static Logger logger = null;

	// ٥˴ؤ餺񤭽Фݤ
	private static boolean isVerboseMode = false;

	private static boolean initialized = false;

	// ̾
	private static final String LOG_NAME = "daruma.log.name";

	/**
	 * LogWriterΥ󥹥ȥ饯<BR>
	 * ʲνԤ롣<BR>
	 * <ol>
	 * <li>Loggerμϥץѥƥ饹
	 *ReadPropertyˤѤ롣</li>
	 * <li>ĶեꤵƤե˽ꡣ</li>
	 * </ol>
	 */
	private static void initialize() {
		String log_name = PropertyReader.getProperty(LOG_NAME);

		logger = Logger.getLogger(log_name);
		PropertyConfigurator.configure(PropertyReader.getFileName());
		initialized = true;
	}

	/**
	 * LogWriterΥ󥹥ȥ饯<BR>
	 * ʲνԤ롣<BR>
	 * <ol>
	 * <li>Loggerμϥץѥƥ饹
	 *ReadPropertyˤѤ롣</li>
	 * <li>ͿURIꤵƤե˽ꡣ</li>
	 * </ol>
	 */
	public static void initialize( URL url ) {
		String log_name = PropertyReader.getProperty(LOG_NAME);

		logger = Logger.getLogger(log_name);
		PropertyConfigurator.configure(url);
		initialized = true;
	}


	/**
	 * verbose ⡼ɤ˰ܹԤޤ
	 * verbose ⡼ɤǤϳƥåΥ٥˴ؤ餺
	 * Ϥޤ
	 */
	public static void setVerbose()
	{
		isVerboseMode = true;
	}


	/**
	 * Ϥޤ<BR>
	 * ܥ饹Υ󥹥󥹤Ƥʤϡ
	 * 󥹥󥹤졢꤬Ԥޤ<br>
	 *
	 * @param str ϥå
	 */
	public static synchronized void write(String str) {

		if (!initialized) {
			initialize();
			initialized = true;
		}

		// ٥뤬ꤵƤʤϡ
		// DEBUGȤư
		write("DEBUG", str);
	}

	/**
	 * Ϥޤ<BR>
	 * ܥ饹Υ󥹥󥹤Ƥʤϡ
	 * 󥹥󥹤꤬Ԥޤ<BR>
	 * ѥ᡼Υ٥LEVELˤϰʲ5बǽǤ<BR>
	 * ʪۤɤפʥ顼Ȥʤޤ
	 * <ul>
	 * <li>DEBUGȯưǧɬפʸĽꡣ</li>
	 * <li>INFO ᥽åɤγϡλĽꡢ¾ư</li>
	 * <li>WARN ư˱ƶͿʤȯԤդʧ٤ȯĽꡣ</li>
	 * <li>ERRORư˸褦ʻȯĽꡣ®䤫˥ץưߤ٤꤬ȯ</li>
	 * <li>FATALץư³ʤ꤬ȯ</li>
	 * </ul>
	 * @param level ٥ERROR, WARN, INFO, DEBUG4椫ϤԤޤ
	 * @param str Ϥå
	 */
	public static synchronized void write(String level, String str) {

		if (!initialized) {
			initialize();
			initialized = true;
		}

		// ٥뤬ꤵƤʤϡ
		// DEBUGȤư
		if (level == null) {
			level = "DEBUG";
		}

		/* !!! [06/08/17 15:14 I.Noda] !!!
		 * 礨 debug ΤˡSystem.err ˤϤʤ餺
		 * Ϥ褦ˤ롣
		 * qwrite ǥ٥åϤƤΤǡ
		 * ̵̤ˤɽʤ
		 */
		System.err.println(level + ":" + str) ;

		if (level.equalsIgnoreCase("ERROR")) {
			logger.error(str);
		} else if (level.equalsIgnoreCase("WARN")) {
			logger.warn(str);
		} else if (level.equalsIgnoreCase("INFO")) {
			logger.info(str);
		} else if (level.equalsIgnoreCase("DEBUG")) {
			logger.debug(str);
		} else if (level.equalsIgnoreCase("FATAL")) {
			logger.fatal(str);
			// throw new RuntimeException();
		} else {
		    /* !!! [06/08/17 15:14 I.Noda] !!!
		     * log level Υ顼Ϥɲ
		     */
		    System.err.println
			("Missing/Unknown log level at LogWriter::write():"
			 + "level=" + level);
		}

		/*
		// for debug, turn on if you don't know where this log is from.
		StackTracePrinter.print();
		System.err.println();
		*/
	}

	/**
	 * ĹѤϴؿ
	 *
	 * @param level ϥ٥򼨤ʸ
	 *              ERROR, WARN, INFO, DEBUG⤫Ĥ򤹤롣
	 * @param args Ϥ
	 */
	public static void qwrite(String level, Object ... args) {
	    try {
		if(isEnabled(level)) {
		    StringBuilder logstr = new StringBuilder();
		    for(Object obj: args) {
			if(obj instanceof Element) {
			    logstr.append(XMLFormatConverter.toString((Element)obj)) ;
			} else {
			    logstr.append(obj);
			}
		    }
		    write(level, logstr.toString());
		}
	    } catch (TransformerException ex) {
		System.err.println
		    ("Fatal!!. "
		     + "Something wrong to convert XML node to String.\n"
		     + "objs=") ;
		for(Object obj: args) {
		    System.err.println(obj.toString()) ;
		}
		ex.printStackTrace(System.err);
		throw new RuntimeException();
	    }
	}


	/**
	 * ٥Υå<BR>
	 */
	public static boolean isEnabled(String level) {
		if (!initialized) {
			initialize();
			initialized = true;
		}

		if ( isVerboseMode )
		{
			return true;
		}

		if (level.equalsIgnoreCase("ERROR")) {
			return logger.isEnabledFor(org.apache.log4j.Level.ERROR) ;
		} else if (level.equalsIgnoreCase("WARN")) {
			return logger.isEnabledFor(org.apache.log4j.Level.WARN);
		} else if (level.equalsIgnoreCase("INFO")) {
			return logger.isEnabledFor(org.apache.log4j.Level.INFO);
		} else if (level.equalsIgnoreCase("DEBUG")) {
			return logger.isEnabledFor(org.apache.log4j.Level.DEBUG);
		} else if (level.equalsIgnoreCase("FATAL")) {
			return logger.isEnabledFor(org.apache.log4j.Level.FATAL) ;
		} else {
		    /* !!! [06/08/17 15:14 I.Noda] !!!
		     * log level Υ顼Ϥɲ
		     */
		    System.err.println
			("Missing/Unknown log level at LogWriter::write():"
			 + "level=" + level + ".");
		    return false ;
		}
	}
}
