package daruma.util.test;

import org.junit.Test;
import junit.framework.TestCase;

import daruma.util.Pair;

import java.util.Map;
import java.util.HashMap;

public class PairTest extends TestCase
{
	@Test
	public void testEquals()
	{
	    Pair<String, Integer> p1 = new Pair<String, Integer>( "foo", 1 );
	    Pair<String, Integer> p2 = new Pair<String, Integer>( "foo", 1 );

	    assertEquals( p2 , p1 );
	}

	@Test
	public void testMap()
	{
	    Map<Pair<String, Integer>, Integer> map;
	    map = new HashMap<Pair<String, Integer>, Integer>();

	    Pair<String, Integer> p1 = new Pair<String, Integer>( "foo", 1 );
	    Pair<String, Integer> p2 = new Pair<String, Integer>( "foo", 1 );

	    map.put( p1 , 100 );

	    assertEquals( new Integer(100) , map.get( p1 ) );
	    assertEquals( new Integer(100) , map.get( p2 ) );
	}
}
