/***
 *** Title: MispDefaultHandler.java
 *** Author: Itsuki Noda
 *** Date: 2006.08.18
 ***/

package daruma.xml.handler;

import java.io.OutputStream;

import org.xml.sax.XMLReader;

import daruma.xml.handler.XSAXDefaultHandler;

import daruma.wfs.ResponseInfo;

import daruma.util.Itk;

/* !!! [06/08/18 23:19 I.Noda] !!! 
 *  wfs β֤XSAXDomCreateHandler δطǡ
 * ֤ʤ⤷XSAXDomCreateHandler Ǥݤˤϡ
 * wfs ذܤȡ
 */
//======================================================================
/**
 * MISP ط SAX Handler ξ̤ǵǽޤȤ뤿Υ饹
 */
public class MispDefaultHandler extends XSAXDefaultHandler
{

    /* !!! [06/08/17 17:28 I.Noda] !!! 
     * transaction ˥ˡ ID ߤ롣
     * transaction Τߤѡ
     */
    private String transactionURI ;
    private long transactionSN ; // transaction serial number

    /* !!! [06/08/19 03:27 I.Noda] !!! 
     * Response ֤DOM Υƥ
     */
    private ResponseInfo response ;

    
    /* !!! [06/08/19 03:27 I.Noda] !!! 
     * ǿ Transaction URI ݻ
     * Transaction κݤˤϡȤäƤϤʤ
     */
    private String mostRecentTransactionURI ;

    //------------------------------------------------------------
    /**
     * constructor
     */
    public MispDefaultHandler(OutputStream out, XMLReader parser,
			      boolean isTopLevelHandler ) {
	super(out, parser, isTopLevelHandler) ;

	this.transactionURI = null ;
	this.response = null ;

    }

    //------------------------------------------------------------
    /**
     * get my parent handler
     * !!! ʼ
     */
    public MispDefaultHandler getMyParentHandler() {
	return (MispDefaultHandler)this.getParentHandler();
    }
    
    //------------------------------------------------------------
    /**
     * TransactionID ɤ߽Ф
     * Transaction URI  null ǡƤФõ
     */
    public String getTransactionURI() {
	if(this.transactionURI == null && this.getParentHandler() != null) {
	    return this.getMyParentHandler().getTransactionURI() ;
	} else {
	    return this.transactionURI ;
	}
    }

    /* !!! [06/08/17 17:28 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * TransactionID 
     */
    public String setTransactionURI(String uri) {
	return this.transactionURI = uri ;
    }

    /* !!! [06/08/17 17:28 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * TransactionID 
     */
    public String setTransactionURI(){
	return setTransactionURI(Itk.genUriRandom()) ;
    }

    /* !!! [06/08/17 17:28 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * TransactionSN ˼
     * Transaction URI  null ǡƤФõ
     */
    public long getTransactionSN() {
	if(this.transactionURI == null && this.getParentHandler() != null) {
	    return this.getMyParentHandler().getTransactionSN() ;
	} else {
	    return this.transactionSN ;
	}
    }

    /* !!! [06/08/17 17:28 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * TransactionSN 
     */
    public long setTransactionSN(long sn) {
	return this.transactionSN = sn ;
    }

    /* !!! [06/08/19 03:27 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * ResponseInfo 
     */
    public ResponseInfo setResponse(ResponseInfo response) {
	return this.response = response ;
    }

    //------------------------------------------------------------
    /**
     * ResponseInfo 
     */
    public ResponseInfo getResponse() {
	if(this.response == null && this.getParentHandler() != null) {
	    return this.getMyParentHandler().getResponse() ;
	} else {
	    return this.response ;
	}
    }

    //------------------------------------------------------------
    /**
     * ResponseInfo 뤫ɤå
     */
    public boolean hasResponse() {
	return this.getResponse() != null ;
    }

    /* !!! [06/08/19 03:27 I.Noda] !!! */
    //------------------------------------------------------------
    /**
     * mostRecentTransactionURI 
     */
    public String setMostRecentTransactionURI(String uri) {
	return this.mostRecentTransactionURI = uri ;
    }

    //------------------------------------------------------------
    /**
     * mostRecentTransactionURI 
     */
    public String getMostRecentTransactionURI() {
	if(this.mostRecentTransactionURI == null && 
	   this.getParentHandler() != null) {
	    return this.getMyParentHandler().getMostRecentTransactionURI() ;
	} else {
	    return this.mostRecentTransactionURI ;
	}
    }




}
