/*
 * 쐬: 2007/10/11
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.jdt;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.jface.preference.IPreferenceStore;

import zigen.plugin.db.ext.jdt.ui.GeneratePreferencePage;


abstract public class CodeGenerator implements ICodeGenerator {
	protected final String line_sep = System.getProperty("line.separator"); //$NON-NLS-1$

	protected final String user_name = System.getProperty("user.name"); //$NON-NLS-1$

	private SimpleDateFormat format1 = new SimpleDateFormat("yyyy/MM/dd"); //$NON-NLS-1$

	// private SimpleDateFormat format2 = new SimpleDateFormat("yyyy/MM/ddHH:mm:ss");

	private StringBuffer out = new StringBuffer();

	boolean generateInfoOn = true;

	boolean classCommentOon = true;

	public CodeGenerator() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		generateInfoOn = store.getBoolean(GeneratePreferencePage.P_GENERATE_INFO_ON);
		classCommentOon = store.getBoolean(GeneratePreferencePage.P_CLASS_COMMENT_ON);
	}

	protected void setGenerateInfo() {
		if (generateInfoOn) {
			println("/* Code Generator Information."); //$NON-NLS-1$
			println(" * generator Version " + Activator.VERSION); //$NON-NLS-1$
			println(" * generated Date " + new Date()); //$NON-NLS-1$
			println(" */"); //$NON-NLS-1$
		}
	}

	protected void setClassComment() {
		if (classCommentOon) {
			println("/**"); //$NON-NLS-1$
			println(" * " + getClassName() + "."); //$NON-NLS-1$ //$NON-NLS-2$
			println(" * @author " + user_name); //$NON-NLS-1$
			println(" * @version 1.0 "); //$NON-NLS-1$
			println(" * history "); //$NON-NLS-1$
			println(" * Symbol\tDate\t\tPerson\t\tNote"); //$NON-NLS-1$
			println(" * [1]\t\t" + format1.format(new Date()) + "\t" + user_name + "\t\t" + "Generated."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			println(" */"); //$NON-NLS-1$
		}
	}

	// Getter\bh̎擾
	protected String getterString(String propertyName) {
		return CodeCreatorUtil.getterString(propertyName);
	}

	// Setter\bh̎擾
	protected String setterString(String propertyName) {
		return CodeCreatorUtil.setterString(propertyName);
	}

	// vpeB̎擾
	protected String propertyString(String accessModifiers, String type, String property) {
		return CodeCreatorUtil.propertyString(accessModifiers, type, property);
	}

	// toString̎擾
	protected String toStringString(String className, String[] properties) {
		return CodeCreatorUtil.toStringString(className, properties);
	}

	/* (non-Javadoc)
     * @see zigen.plugin.db.ext.jdt.ICodeGenerator#execute()
     */
	abstract public void execute();

	/* (non-Javadoc)
     * @see zigen.plugin.db.ext.jdt.ICodeGenerator#getClassName()
     */
	abstract public String getClassName();

	protected void println() {
		println(""); //$NON-NLS-1$
	}

	protected void println(String str) {
		out.append(str + line_sep);
	}

	protected void print(String str) {
		out.append(str);
	}

	/* (non-Javadoc)
     * @see zigen.plugin.db.ext.jdt.ICodeGenerator#setPackageString(java.lang.String)
     */
	public void setPackageString(String pkgName) {
		// ftHgpbP[WIꍇInsertȂ
		if (pkgName != null && !pkgName.equals("")) { //$NON-NLS-1$
			out.insert(0, "package " + pkgName + ";" + line_sep + line_sep); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/* (non-Javadoc)
     * @see zigen.plugin.db.ext.jdt.ICodeGenerator#genaratedString()
     */
	public String genaratedString() {
		return out.toString();
	}

}
