/*
 * 쐬: 2005/03/28
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

/**
 * 
 * DefaultInsertMappingFactory.javaNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/05/06 ZIGEN create.
 * 
 */
abstract public class DefaultSQLCreatorFactory extends AbstractSQLCreatorFactory implements ISQLCreatorFactory {

	protected Column[] cols;

	protected TablePKColumn[] pks;

	protected String primaryKeyName = null; // UniqueIndexƂ̏dh

	protected List fks;

	protected List uidxs;

	DefaultSQLCreatorFactory(ITable table) {
		setTable(table);
	}

	protected void setTable(ITable table) {
		this.table = table;
		this.cols = table.getColumns(); // tablevfJvf擾
		this.pks = table.getTablePKColumns();
		this.fks = convertTableFKColumn(table.getTableFKColumns());
		this.uidxs = convertTableIDXColumn(table.getTableUIDXColumns());
	}

	// Ogp
	public List convertTableIDXColumn(TableIDXColumn[] idxs) {

		if (idxs == null)
			return null;
		List result = new ArrayList();

		String temp = "";
		for (int i = 0; i < idxs.length; i++) {

			TableIDXColumn idx = idxs[i];
			List list = new ArrayList();
			list.add(idx);
			temp = idx.getName();

			for (int k = i + 1; k < idxs.length; k++) {
				TableIDXColumn _idx = idxs[k];
				if (!temp.equals(_idx.getName())) {

					temp = _idx.getName();
					result.add((TableIDXColumn[]) list.toArray(new TableIDXColumn[0]));

					break;
				} else {
					list.add(_idx);
					i++;
				}
			}

			if (i >= idxs.length - 1) {
				result.add((TableIDXColumn[]) list.toArray(new TableIDXColumn[0]));
			}
		}

		return result;
	}

	// Ogp
	public List convertTableConstraintColumn(TableConstraintColumn[] cons) {

		if (cons == null)
			return null;
		List result = new ArrayList();

		String temp = "";
		for (int i = 0; i < cons.length; i++) {

			TableConstraintColumn con = cons[i];
			List list = new ArrayList();
			list.add(con);
			temp = con.getName();

			for (int k = i + 1; k < cons.length; k++) {
				TableConstraintColumn _wk = cons[k];
				if (!temp.equals(_wk.getName())) {

					temp = _wk.getName();
					result.add((TableConstraintColumn[]) list.toArray(new TableConstraintColumn[0]));

					break;
				} else {
					list.add(_wk);
					i++;
				}
			}

			if (i >= cons.length - 1) {
				result.add((TableConstraintColumn[]) list.toArray(new TableConstraintColumn[0]));
			}
		}

		return result;
	}

	// Ogp
	public List convertTableFKColumn(TableFKColumn[] fks) {

		if (fks == null)
			return null;
		List result = new ArrayList();

		String temp = "";
		for (int i = 0; i < fks.length; i++) {
			TableFKColumn fk = fks[i];
			List list = new ArrayList();
			list.add(fk);
			temp = fk.getName();

			for (int k = i + 1; k < fks.length; k++) {
				TableFKColumn _fkc = fks[k];
				if (!temp.equals(_fkc.getName())) {
					temp = _fkc.getName();
					result.add((TableFKColumn[]) list.toArray(new TableFKColumn[0]));
					break;
				} else {
					list.add(_fkc);
					i++;;
				}
			}

			if (i >= fks.length - 1) {
				result.add((TableFKColumn[]) list.toArray(new TableFKColumn[0]));
			}
		}

		return result;
	}

	public String createDDL() {
		return getCreateTableStr();
	}

	protected String getCreateTableStr() {
		StringBuffer sb = new StringBuffer();
		sb.append("CREATE TABLE ");
		sb.append(table.getSqlTableName());
		sb.append(DbPluginConstant.LINE_SEP);
		sb.append("(");
		sb.append(DbPluginConstant.LINE_SEP);
		sb.append(getColumnDefine());
		sb.append(getConstraints());
		sb.append(")");
		setDemiliter(sb);
		return sb.toString();
	}

	protected boolean hasPrimaryKey() {
		return pks != null && pks.length > 0;
	}

	protected boolean hasForeginKey() {
		return fks != null && fks.size() > 0;
	}

	protected boolean hasUniqueIndexKey() {
		return uidxs != null && uidxs.size() > 0;
	}

	protected String getColumnDefine() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < cols.length; i++) {
			Column col = cols[i];
			TableColumn column = col.getColumn();

			if (i == cols.length - 1) {
				sb.append(getColumnLabel(column));

				if (column.isNotNull()) {
					sb.append(" NOT NULL");
				}

				if (hasPrimaryKey() || hasForeginKey() || hasUniqueIndexKey()) {
					sb.append(",");
				}

				sb.append(DbPluginConstant.LINE_SEP);

			} else {
				sb.append(getColumnLabel(column));
				if (column.isNotNull()) {
					sb.append(" NOT NULL");
				}
				sb.append(",");
				sb.append(DbPluginConstant.LINE_SEP);
			}
		}
		return sb.toString();
	}

	/**
	 * J{^{
	 * 
	 * @return
	 */
	protected String getColumnLabel(TableColumn column) {

		StringBuffer sb = new StringBuffer();
		sb.append("    ");
		sb.append(StringUtil.padding(column.getColumnName(), 28));

		String typeName = column.getTypeName().toUpperCase();

		sb.append(typeName);

		if (isVisibleColumnSize(typeName)) {
			if (column.getDecimalDigits() == 0) {
				sb.append("(" + column.getColumnSize() + ")");
			} else {
				sb.append("(" + column.getColumnSize() + "," + column.getDecimalDigits() + ")");
			}
		}

		return sb.toString();
	}

	protected String getConstraintPKStr() {
		StringBuffer sb = new StringBuffer();
		if (pks == null || pks.length == 0)
			return null;

		int i = 0;
		for (i = 0; i < pks.length; i++) {
			TablePKColumn pkc = pks[i];
			if (i == 0) {
				primaryKeyName = pkc.getName();
				sb.append("CONSTRAINT ");
				sb.append(pkc.getName());
				sb.append(" PRIMARY KEY ");
				sb.append("(");
				sb.append(pkc.getColumnName());
			} else {
				sb.append(", " + pkc.getColumnName());
			}

		}
		sb.append(")");
		return sb.toString();
	}

	protected String[] getConstraintFKStr() {

		if (fks == null)
			return null;

		List result = new ArrayList();
		for (Iterator iter = fks.iterator(); iter.hasNext();) {
			TableFKColumn[] _fks = (TableFKColumn[]) iter.next();

			StringBuffer sb = new StringBuffer();
			StringBuffer sb2 = new StringBuffer();
			boolean cascade = false;
			for (int i = 0; i < _fks.length; i++) {
				TableFKColumn column = _fks[i];
				cascade = column.isCasucade();

				if (i == 0) {
					sb.append("CONSTRAINT ");
					sb.append(column.getName());
					sb.append(" FOREIGN KEY ");
					sb.append("(");
					sb.append(column.getColumnName());

					// Reference
					sb2.append(" REFERENCES ");
					if (column.getPkSchema() != null) {
						sb2.append(column.getPkSchema());
						sb2.append(".");
					}
					sb2.append(column.getPkTableName());
					sb2.append(" ");
					sb2.append("(");
					sb2.append(column.getPkColumnName());

				} else {

					sb.append(", " + column.getColumnName());
					sb2.append(", " + column.getColumnName());
				}

			}
			sb.append(")");
			sb2.append(")");
			if (cascade) {
				sb2.append(" ON DELETE CASCADE");
			}
			result.add(sb.toString() + sb2.toString());
		}

		return (String[]) result.toArray(new String[0]);

	}

	protected String[] getConstraintIDXStr() {

		if (uidxs == null)
			return null;

		List result = new ArrayList();
		for (Iterator iter = uidxs.iterator(); iter.hasNext();) {
			TableIDXColumn[] _idxs = (TableIDXColumn[]) iter.next();

			StringBuffer sb = new StringBuffer();
			// StringBuffer sb2 = new StringBuffer();
			// boolean cascade = false;
			for (int i = 0; i < _idxs.length; i++) {
				TableIDXColumn column = _idxs[i];

				if (column.getName().equals(primaryKeyName))
					break; // PKƏdĂꍇ͔

				// cascade = column.isCasucade();

				if (i == 0) {

					sb.append("CONSTRAINT ");
					sb.append(column.getName());
					sb.append(" UNIQUE ");
					sb.append("(");
					sb.append(column.getColumnName());

				} else {
					sb.append(", " + column.getColumnName());
					// sb2.append(", " + column.getColumnName());
				}

				if (i == _idxs.length - 1) {
					sb.append(")");
				}

			}

			// sb2.append(")");
			/*
			 * if (cascade) { sb2.append(" ON DELETE CASCADE"); }
			 */
			// result.add(sb.toString() + sb2.toString());
			if (sb.length() != 0) {
				result.add(sb.toString());
			}

		}

		return (String[]) result.toArray(new String[0]);

	}

	/**
	 * 񕶎̍쐬
	 * 
	 * @param header
	 * @return
	 */
	protected String getConstraints() {
		StringBuffer sb = new StringBuffer();

		String pks = getConstraintPKStr();
		String[] fks = getConstraintFKStr();
		String[] idxs = getConstraintIDXStr();

		if (fks != null) {
			for (int i = 0; i < fks.length; i++) {
				if (i == fks.length - 1) {
					sb.append("    " + fks[i]);
					if (pks != null) {
						sb.append(",");
					}
					sb.append(DbPluginConstant.LINE_SEP);

				} else {
					sb.append("    " + fks[i] + ",");
					sb.append(DbPluginConstant.LINE_SEP);
				}

			}
		}

		if (pks != null) {
			sb.append("    " + pks);
			if (idxs != null && idxs.length > 0) {
				sb.append(",");

			}
			sb.append(DbPluginConstant.LINE_SEP);
		} else {

		}

		if (idxs != null) {
			for (int i = 0; i < idxs.length; i++) {
				if (i == idxs.length - 1) {
					sb.append("    " + idxs[i]);

					// if (pks != null) {
					// sb.append(",");
					// }
					sb.append(DbPluginConstant.LINE_SEP);

				} else {
					sb.append("    " + idxs[i] + ",");
					sb.append(DbPluginConstant.LINE_SEP);
				}

			}
		}

		return sb.toString();
	}

	public String createSelect(String condition, int limit) {
		StringBuffer sb = new StringBuffer();

		sb.append("SELECT * FROM ");
		sb.append(table.getSqlTableName());

		if (condition != null && !"".equals(condition.trim())) {
			sb.append(" WHERE " + condition);
		}

		return sb.toString();
	}

	public String VisibleColumnSizePattern() {
		return ".*CHAR|^VARCHAR.*|^NUMBER|^DECIMAL|.*INT.*|^FLOAT|^DOUBLE|^REAL|^TIMESTAMP|^TIME|.*VARYING";
	}

	public boolean isVisibleColumnSize(String typeName) {
		return typeName.toUpperCase().matches(VisibleColumnSizePattern());
	}

	public String[] getSupportColumnType() {
		return new String[] {
				"INT",
				"INTEGER",
				"DOUBLE",
				"FLOAT",
				"VARCHAR",
				"CHAR",
				"DECIMAL",
				"NUMERIC",
				"BOOLEAN",
				"BIT",
				"TINYINT",
				"SMALLINT",
				"BIGINT",
				"REAL",
				"BINATY",
				"VARBINATY",
				"LONGBINARY",
				"DATE",
				"TIME",
				"TIMESTAMP",
				"DATETIME",
				"OTHER",
				"OBJECT"
		};
	}

	public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createDropIndexDDL(String indexName) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createCreateConstraintCheckDDL(String constraintName, String check) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public String createDropConstraintDDL(String constraintName, String type) {
		throw new UnsupportedOperationException("Versionł́AĂ܂");
	}

	public boolean supportsRollbackDDL() {
		return false;
	}

	// public boolean supportsRemarks() {
	// return false;
	// }
	//
	// public boolean supportsModifyColumnType() {
	// return false;
	// }
	//
	// public boolean supportsModifyColumnSize(String columnType) {
	// return false;
	// }
	//
	// public String getCommentTableDDL(String commnets) {
	// throw new UnsupportedOperationException("e[ũRgǉ@\̓T|[gĂ܂");
	// }
	//
	// public String getCommentColumnDDL(Column column) {
	// throw new UnsupportedOperationException("J̃Rgǉ@\̓T|[gĂ܂");
	//
	// }
	//
	// public String getRenameTableDDL(String newTableName) {
	// throw new UnsupportedOperationException("e[u̕ύX@\̓T|[gĂ܂");
	//
	// }
	//
	// public String getRenameColumnDDL(Column from, Column to) {
	// throw new UnsupportedOperationException("J̕ύX@\̓T|[gĂ܂");
	//
	// }
	//
	// public String[] getAddColumnDDL(Column column) {
	// throw new UnsupportedOperationException("Jǉ@\̓T|[gĂ܂");
	// }
	//
	// public String[] getModifyColumnDDL(Column from, Column to) {
	// throw new UnsupportedOperationException("JҏW@\̓T|[gĂ܂");
	//
	// }
	//
	// public String[] getDropColumnDDL(Column column) {
	// throw new UnsupportedOperationException("J폜@\̓T|[gĂ܂");
	// }

}