/*
 * 쐬: 2005/03/28 쌠: Copyright (c) 2005 ZIGEN CZXFCommon Public License - v 1.0 Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.csv;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

/**
 * OracleMappingFactory.java.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/11/26 ZIGEN create.
 * 
 */
public class OracleCsvMappingFactory extends DefaultCsvMappingFactory implements ICsvMappingFactory {
	/**
	 * Oracle9iŌÂJDBCDriveŕATIMESTAMP^-100Ԃ
	 */
	public static final int ORACLE_TIMESTAMP = -100;

	public OracleCsvMappingFactory(boolean convertUnicode, boolean nonDoubleQuate) {
		super(convertUnicode, nonDoubleQuate);
	}

	public String getCsvValue(ResultSet rs, int icol) throws SQLException {
		ResultSetMetaData rmd = rs.getMetaData();
		int type = rmd.getColumnType(icol);
		switch (type) {
		// Driverł\ȂAȉ̃RgO
		// case ORACLE_TIMESTAMP: // -100
		// return getTimestamp(rs, icol);
		default:
			return super.getCsvValue(rs, icol);
		}
	}

	protected String getDate(ResultSet rs, int icol) throws SQLException {
		Timestamp value = rs.getTimestamp(icol);

		if (rs.wasNull()) {
			return NULL;
		}

		return timeStampFormat.format(new Date(value.getTime()));

	}

	protected String getTimestamp(ResultSet rs, int icol) throws SQLException {

		Timestamp value = rs.getTimestamp(icol);

		if (rs.wasNull()) {
			return NULL;
		}

		return timeStampFormat2.format(new Date(value.getTime()));

	}

}