package zigen.plugin.db.diff;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;

public class DDLDiffViewer extends TextMergeViewer {

	public DDLDiffViewer(Composite parent, CompareConfiguration configuration) {
		super(parent, configuration);
	}

	public void addToolItems(IToolBarManager tbm) {
		tbm.add(new Separator("modes")); //$NON-NLS-1$
		tbm.add(new Separator("navigation")); //$NON-NLS-1$
		tbm.add(new Separator("merge")); //$NON-NLS-1$

		createToolItems((ToolBarManager) tbm);

		hideGroupItems(tbm.getItems(), "merge"); //$NON-NLS-1$

	}

	private void hideGroupItems(IContributionItem[] items, String groupId) {
		boolean readingGroupItems = false;
		for (int i = 0; i < items.length; ++i) {
			IContributionItem item = items[i];
			if (readingGroupItems) {
				item.setVisible(false);
			}
			if (item instanceof Separator && item.getId() != null) {
				readingGroupItems = groupId.equals(item.getId());
			}
		}
	}
}
