/*
 * 쐬: 2005/08/21
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.dialogs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;

/**
 * SelectTableWizardPageNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/08/21 ZIGEN create.
 * 
 */
public class WizardPage3 extends DefaultWizardPage {

	public static final String MSG = Messages.getString("WizardPage3.0"); //$NON-NLS-1$

	Group group5;

	public WizardPage3(ISelection selection) {
		super(Messages.getString("WizardPage3.1")); //$NON-NLS-1$
		setTitle(Messages.getString("WizardPage3.2")); //$NON-NLS-1$
		setPageComplete(true);
	}

	Text charsetText;

	public void createControl(Composite parent) {
		Composite container = createDefaultComposite(parent);

		Group group1 = new Group(container, SWT.NONE);
		group1.setText(Messages.getString("WizardPage3.3")); //$NON-NLS-1$
		group1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group1.setLayout(new GridLayout(1, false));
		addCharsetSection(group1);

		Group group2 = new Group(container, SWT.NONE);
		group2.setText(Messages.getString("WizardPage3.4")); //$NON-NLS-1$
		group2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group2.setLayout(new GridLayout(1, false));
		addConvertUnicodeSection(group2);

		Group group3 = new Group(container, SWT.NONE);
		group3.setText(Messages.getString("WizardPage3.5")); //$NON-NLS-1$
		group3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group3.setLayout(new GridLayout(1, false));
		addAutoCommitSection(group3);

		Group group4 = new Group(container, SWT.NONE);
		group4.setText(Messages.getString("WizardPage3.6")); //$NON-NLS-1$
		group4.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group4.setLayout(new GridLayout(1, false));
		addOnlyDefaultSchemaSection(group4);

		group5 = new Group(container, SWT.NONE);
		group5.setText(Messages.getString("WizardPage3.7")); //$NON-NLS-1$
		group5.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		group5.setLayout(new GridLayout(1, false));
		addNoLockModeSection(group5);

		setControl(container);
	}

	private void addCharsetSection(Composite group) {
		charsetText = new Text(group, SWT.SINGLE | SWT.BORDER);
		charsetText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		charsetText.addFocusListener(new TextSelectionListener());

		if (getOldConfig() != null) {
			// o[WpNULL`FbN
			if (getOldConfig().getCharset() != null)
				charsetText.setText(getOldConfig().getCharset());
		} else {
			charsetText.setText(DEFAULT_CHARSET);
		}
	}

	Button unicodeCheck;

	Button commitModeCheck;

	Button schemaOnlyCheck;

	Button symfowareOptionCheck;

	private void addConvertUnicodeSection(Composite group) {
		unicodeCheck = new Button(group, SWT.CHECK);
		unicodeCheck.setText(Messages.getString("WizardPage3.8")); //$NON-NLS-1$
		if (getOldConfig() != null) {
			unicodeCheck.setSelection(getOldConfig().isConvertUnicode());
		} else {
			unicodeCheck.setSelection(DEFAULT_CONVERTUNICODE);
		}
	}

	private void addAutoCommitSection(Composite group) {
		commitModeCheck = new Button(group, SWT.CHECK);
		commitModeCheck.setText(Messages.getString("WizardPage3.9")); //$NON-NLS-1$
		if (getOldConfig() != null) {
			commitModeCheck.setSelection(getOldConfig().isAutoCommit());
		} else {
			commitModeCheck.setSelection(DEFAULT_AUTOCOMMIT);
		}
	}

	private void addOnlyDefaultSchemaSection(Composite group) {
		schemaOnlyCheck = new Button(group, SWT.CHECK);
		schemaOnlyCheck.setText(Messages.getString("WizardPage3.10")); //$NON-NLS-1$
		if (getOldConfig() != null) {
			schemaOnlyCheck.setSelection(getOldConfig().isOnlyDefaultSchema());
		} else {
			schemaOnlyCheck.setSelection(ONLY_DEFAULT_SCHEMA);
		}
	}

	private void addNoLockModeSection(Composite group) {
		symfowareOptionCheck = new Button(group, SWT.CHECK);
		symfowareOptionCheck.setText(Messages.getString("WizardPage3.11")); //$NON-NLS-1$
		symfowareOptionCheck.setSelection(true); // lTrue
		if (getOldConfig() != null) {
			symfowareOptionCheck.setSelection(getOldConfig().isNoLockMode());
		} else {
			symfowareOptionCheck.setSelection(DEFAULT_NO_LOCK_MODE);
		}
	}

	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			setDescription(MSG);

			DBConfigWizard wiz = (DBConfigWizard) getWizard();
			Object page = wiz.getPreviousPage(this);
			if (page instanceof WizardPage2) {
				WizardPage2 page2 = (WizardPage2) page;
				page2.searchDriverFlg = false;

				String driver = page2.driverCombox.getText();
				if (driver != null && !"".equals(driver)) { //$NON-NLS-1$
					if (DBType.getType(driver) == DBType.DB_TYPE_SYMFOWARE) {
						group5.setVisible(true);
						symfowareOptionCheck.setEnabled(true);
					} else {
						group5.setVisible(false);
						symfowareOptionCheck.setEnabled(false);
						symfowareOptionCheck.setSelection(false);
					}
				}

			}
		}
	}
}
