/*
 * 쐬: 2005/03/26
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.diff.DDLDiffJob;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.ITableViewEditorAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.event.TableDefaultSortListener;
import zigen.plugin.db.ui.editors.event.TableSortListener;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.ChangeColorJob;
import zigen.plugin.db.ui.jobs.RecordCountForQueryJob;
import zigen.plugin.db.ui.views.StatusLineContributionItem;

/**
 * TableEditorNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 */
public class QueryViewEditor2 extends MultiPageEditorPart implements ITableViewEditor {

	private Table table;

	private TableViewer viewer;

	private TableElement[] elements;

	private String query;

	private IDBConfig config = null;

	private TableSortListener sortListener;

	protected StatusLineContributionItem responseTimeItem;

	protected String responseTime;

	protected SelectAllRecordAction selectAllRecordAction;

	protected CopyRecordDataAction copyAction;

	protected ChangeColorJob changeColorJob;

	protected Label infoLabel;

	public QueryViewEditor2() {
		super();
	}

	public void setInfomationText(String message) {
		infoLabel.setText(message);
	}

	private void makeActions() {
		selectAllRecordAction = new SelectAllRecordAction();
		copyAction = new CopyRecordDataAction();
		selectAllRecordAction.setActiveEditor(this);
		copyAction.setActiveEditor(this);

	}

	protected void createPages() {
		makeActions();
		createLogPage();
	}

	private void createLogPage() {
		Composite composite = new Composite(getContainer(), SWT.NONE);
		composite.setLayout(new FillLayout());
		int index = addPage(composite);
		setPageText(index, "log"); //$NON-NLS-1$
	}

	private boolean hasContributionItem(IStatusLineManager manager, String id) {
		IContributionItem[] items = manager.getItems();
		for (int i = 0; i < items.length; i++) {
			IContributionItem item = items[i];
			if (item.getId().equals(id)) {
				responseTimeItem = (StatusLineContributionItem) item;
				return true;
			}
		}
		return false;
	}

	public void contributeToStatusLine() {
		IEditorSite site = super.getEditorSite();
		IActionBars actionBars = site.getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();

		if (!hasContributionItem(manager, "RecordCount")) { //$NON-NLS-1$
			responseTimeItem = new StatusLineContributionItem("RecordCount"); //$NON-NLS-1$
			manager.add(responseTimeItem);
		}

	}

	private void createMessageArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL)); // ㉺L
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		infoLabel = new Label(composite, SWT.NONE);
		infoLabel.setText(""); //$NON-NLS-1$
		infoLabel.setForeground(new Color(null, 255, 0, 0));
	}

	private void createMainPage() {
		Composite main = new Composite(getContainer(), SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		main.setLayout(gridLayout);

		table = new Table(main, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gridData2 = new GridData(GridData.FILL_BOTH);
		table.setLayoutData(gridData2);
		table.setHeaderVisible(true);// wb_ɂ
		table.setLinesVisible(true); // C\
		table.setFont(DbPlugin.getDefaultFont());

		viewer = new TableViewer(table);
		setHeaderColumn(table);
		viewer.setContentProvider(new TableViewContentProvider());
		viewer.setLabelProvider(new TableViewLabelProvider());

		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent e) {
				setGlobalAction();
			}
		});

		viewer.setInput(elements);

		changeColorJob = new ChangeColorJob(table);
		changeColorJob.setPriority(ChangeColorJob.LONG);
		changeColorJob.setUser(false);
		changeColorJob.schedule();

		columnsPack(table);
		createMessageArea(main);
		hookContextMenu();
		contributeToStatusLine();

		if (this.getPageCount() > 1) { // Õy[WȊO
			this.removePage(getPageCount() - 1);
		}

		// Py[WڂƂēo^Aindexԍ擾
		int index = addPage(main);

		// Ō̃V[gANeBuɂ
		setActivePage(getPageCount() - 1);

		// SelectionProviderɓo^(ύXʒm邽߁j
		getSite().setSelectionProvider(viewer);

	}

	public void setTotalCount(String dispCount, String totalCount) {
		StringBuffer sb = new StringBuffer();
		sb.append(dispCount);
		sb.append(Messages.getString("QueryViewEditor2.3")); //$NON-NLS-1$

		if (!"".equals(totalCount)) { //$NON-NLS-1$
			if ("-1".equals(totalCount)) { //$NON-NLS-1$
				; // Ή̏ꍇ͉Ȃ
			} else {
				sb.append(" / "); //$NON-NLS-1$
				sb.append(Messages.getString("QueryViewEditor2.7")); //$NON-NLS-1$
				sb.append(totalCount);
				sb.append(Messages.getString("QueryViewEditor2.8")); //$NON-NLS-1$
			}
		} else {
			sb.append(Messages.getString("QueryViewEditor2.9")); //$NON-NLS-1$
		}
		sb.append(Messages.getString("QueryViewEditor2.10")); //$NON-NLS-1$
		sb.append(responseTime);
		sb.append("]"); //$NON-NLS-1$

		setPageText(getActivePage(), sb.toString());
	}

	public void setResponseTime(String responseTime) {
		this.responseTime = responseTime;

		if (responseTimeItem != null && responseTime != null && !"".equals(responseTime)) { //$NON-NLS-1$
			StringBuffer sb = new StringBuffer();
			sb.append(Messages.getString("QueryViewEditor2.13")); //$NON-NLS-1$
			sb.append(responseTime);
			responseTimeItem.setText(sb.toString());

		}
	}

	public void update(String query, TableElement[] elements, String responseTime) {
		try {
			// Query͒u
			this.query = query;

			if (viewer == null) {
				this.elements = elements;
				createMainPage();
			} else {
				TableElement element = elements[0];
				if (isSameColumn(element)) {
					viewer.setInput(elements);
					TableColumn col = viewer.getTable().getColumn(0);
					col.pack();// 擪̕pbN
					TableDefaultSortListener defaultSortListener = new TableDefaultSortListener(this, 0);
					// sortListenerU폜
					col.removeSelectionListener(sortListener);
					// \pSortListenero^
					col.addSelectionListener(defaultSortListener);
					viewer.getTable().getColumn(0).notifyListeners(SWT.Selection, null);
					// ̃Xi[ɖ߂
					col.removeSelectionListener(defaultSortListener);
					sortListener = new TableSortListener(this, 0);
					col.addSelectionListener(sortListener);

				} else {
					// NG[Ⴄꍇ
					this.elements = elements;
					createMainPage();
				}
			}

			// SQLsĂViewANeBuɂ
			QueryViewEditorInput ei = (QueryViewEditorInput) getEditorInput();
			DbPlugin.showView(DbPluginConstant.VIEW_ID_SQLExecute, ei.getSecondarlyId());

			// Ԃ̕\
			setResponseTime(responseTime);

			// R[h̕\
			int dispCnt = elements.length - 1;
			NumberFormat format = NumberFormat.getInstance();
			String displayCount = format.format(dispCnt);
			setTotalCount(displayCount, ""); //$NON-NLS-1$

			QueryViewEditorInput input = (QueryViewEditorInput) getEditorInput();
			RecordCountForQueryJob job2 = new RecordCountForQueryJob(Transaction.getInstance(config), query, input.getSecondarlyId(), dispCnt);
			job2.setUser(false);
			job2.setPriority(RecordCountForQueryJob.LONG);
			job2.schedule();

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				getContributor().fillContextMenu(manager);
				setExtensionPoint(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	private QueryViewerContributor getContributor() {
		IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
		if (contributor instanceof QueryViewerContributor) {
			return (QueryViewerContributor) contributor;
		} else {
			return null;
		}
	}

	private void setHeaderColumn(Table table) {
		if (elements != null) {
//			TableColumn row = new TableColumn(table, SWT.LEFT);
            TableColumn row = new TableColumn(table, SWT.RIGHT);
            
			sortListener = new TableSortListener(this, 0);
			row.addSelectionListener(sortListener);
			row.pack();
			TableElement element = elements[0]; // wb_[pJ
			zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
			for (int i = 0; i < columns.length; i++) {
				zigen.plugin.db.core.TableColumn tColumn = columns[i];
				TableColumn col = new TableColumn(table, SWT.LEFT);
				col.setText(tColumn.getColumnName());
				col.addSelectionListener(new TableSortListener(this, i + 1));
				col.pack();
			}
		}
	}

	private void columnsPack(Table table) {
		table.setVisible(false);
		TableColumn[] cols = table.getColumns();
		for (int i = 0; i < cols.length; i++) {
			cols[i].pack();
		}
		table.setVisible(true);
	}

	public void dispose() {
		disposeExtensionPoint();
		super.dispose();
	}

	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public boolean isSaveAsAllowed() {
		return false; // j[ۑIłȂ悤ɂ
	}

	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		super.init(site, editorInput);
		try {

			if (editorInput instanceof QueryViewEditorInput) {
				QueryViewEditorInput input = (QueryViewEditorInput) editorInput;
				this.config = input.getConfig();
				this.query = input.getQuery();

				setPartName("[" + config.getDbName() + Messages.getString("QueryViewEditor2.17")); //$NON-NLS-1$ //$NON-NLS-2$
			}

		} catch (Exception e) {
			// Editor
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	protected void pageChange(int newPageIndex) {
		super.pageChange(newPageIndex);
	}

	public TableViewer getViewer() {
		return viewer;
	}

	public ITable getTableNode() {
		return null;
	}

	public TableElement getHeaderTableElement() {
		if (this.elements.length > 0) {
			return elements[0];
		}
		return null;
	}

	protected void initializeViewerFont(ISourceViewer viewer) {
		StyledText styledText = viewer.getTextWidget();
		styledText.setFont(DbPlugin.getDefaultFont());
	}

	void setGlobalAction() {
		IActionBars bars = getEditorSite().getActionBars();
		bars.clearGlobalActionHandlers();
		copyAction.refresh();
		bars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
		bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAllRecordAction);
		bars.updateActionBars();

	}

	public void setFocus() {
		if (table != null && copyAction != null && selectAllRecordAction != null) {
			setGlobalAction();
			table.setFocus();
			setResponseTime(responseTime);
		}
	}

	private boolean isSameColumn(TableElement target) {
		if (this.elements == null)
			return false;

		TableElement old = this.elements[0];
		zigen.plugin.db.core.TableColumn[] oldCols = old.getColumns();
		zigen.plugin.db.core.TableColumn[] targetCols = target.getColumns();
		int oldLen = oldCols.length;
		int targetLen = targetCols.length;

		if (oldLen != targetLen)
			return false;

		for (int i = 0; i < oldCols.length; i++) {
			zigen.plugin.db.core.TableColumn column1 = oldCols[i];
			zigen.plugin.db.core.TableColumn column2 = targetCols[i];
			if (!column1.getColumnName().equals(column2.getColumnName())) {
				return false;
			}
		}
		return true;
	}

	public IDBConfig getDBConfig() {
		return config;
	}

	public String getQuery() {
		return query;
	}

	public void changeColumnColor(Column column) {
//		changeColorJob.setSelectedColumn(column);
//		changeColorJob.schedule();

	}

	public void changeColumnColor() {
		changeColorJob.setTable(table);
		changeColorJob.schedule();
	}

	public void editTableElement(Object element, int column) {
		throw new UnsupportedOperationException("editTableElementQueryViewEditorł͖ł"); //$NON-NLS-1$
	}

	public String getCondition() {
		throw new UnsupportedOperationException("getConditionQueryViewEditorł͖ł"); //$NON-NLS-1$
	}

	private List extensionList = new ArrayList();

	private void setExtensionPoint(IMenuManager manager) {

		IExtensionRegistry registry = Platform.getExtensionRegistry();
		// g|Cg擾
		IExtensionPoint point = registry.getExtensionPoint(DbPlugin.getDefault().getBundle().getSymbolicName() + ".tableEditor");
		// Rgr[gꂽg擾
		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			add(manager, elements);
		}

	}

	private void add(IMenuManager menu, IConfigurationElement[] elems) {

		try {
			for (int k = 0; k < elems.length; k++) {

				IConfigurationElement element = elems[k];
				String name = element.getName();

				if ("contributor".equals(name)) {
					try {
						// classŎw肳ꂽNX
						ITableViewEditorAction action = (ITableViewEditorAction) element.createExecutableExtension("class");
						action.setText(element.getAttribute("label"));
						action.setToolTipText(element.getAttribute("tooltipText"));
						action.setActiveEditor(this);
						action.selectionChanged(viewer.getSelection());
						extensionList.add(action);

						String menubarPath = element.getAttribute("menubarPath");
						IMenuManager subMenu = menu.findMenuUsingPath(menubarPath);

						if (subMenu != null) {
							subMenu.add(action);
							add(subMenu, element.getChildren());
						} else {
							IContributionItem item = menu.findUsingPath(menubarPath);
							if (item != null) {
								if (item instanceof Separator) {
									Separator sep = (Separator) item;
									IContributionManager mgr = sep.getParent();
									mgr.add(action);
									add(subMenu, element.getChildren());
								} else if (item instanceof GroupMarker) {
									GroupMarker sep = (GroupMarker) item;
									IContributionManager mgr = sep.getParent();
									mgr.add(action);
									add(subMenu, element.getChildren());
								} else {
									DbPlugin.log("unexpected Type " + item.getClass().getName());
								}
							}
						}

					} catch (Exception ex) {
						ex.printStackTrace();
					}
				} else if ("menu".equals(name)) {
					String _id = element.getAttribute("id");
					String _label = element.getAttribute("label");
					IMenuManager subMenu = menu.findMenuUsingPath(_id);
					if (subMenu == null) {
						subMenu = new MenuManager(_label, _id);
						menu.add(subMenu);
						add(subMenu, element.getChildren());
					}

				} else if ("separator".equals(name)) {
					String _name = element.getAttribute("name");
					menu.add(new Separator(_name));

				} else if ("groupMarker".equals(name)) {
					String _name = element.getAttribute("name");
					menu.add(new GroupMarker(_name));

				}

			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}
	}

	private void disposeExtensionPoint() {
		// gĂ郊Xi[j
		for (Iterator iter = extensionList.iterator(); iter.hasNext();) {
			ITableViewEditorAction action = (ITableViewEditorAction) iter.next();
			action.setActiveEditor(null);
			action = null;
		}
	}
}
