/*
 * 쐬: 2006/02/08
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.event;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableNewElement;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.rule.AbstractValidatorFactory;
import zigen.plugin.db.core.rule.IValidatorFactory;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.actions.InsertRecordAction;
import zigen.plugin.db.ui.editors.CellModifier;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.TextCellEditor;
import zigen.plugin.db.ui.editors.exceptions.UpdateException;
import zigen.plugin.db.ui.editors.exceptions.ZeroUpdateException;
import zigen.plugin.db.ui.editors.internal.RecordUpdateThread;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.RecordUpdateJob;

/**
 * 
 * TableKeyEventHandlerNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/02/08 ZIGEN create.
 * 
 */
public class TableKeyEventHandler {

	protected TableViewEditorFor31 editor;

	protected TableViewer viewer;

	protected Table table;

	protected IDBConfig config;

	/**
	 * RXgN^
	 * 
	 */
	public TableKeyEventHandler(TableViewEditorFor31 editor) {
		this.editor = editor;
		this.viewer = editor.getViewer();
		this.table = editor.getViewer().getTable();
		this.config = editor.getDBConfig();
	}

	/**
	 * IĂsԍ擾
	 * 
	 * @return
	 */
	public int getSelectedRow() {
		return table.getSelectionIndex(); // si擪0)
	}

	public void selectRow(int index) {
		table.select(index);
	}

	/**
	 * IĂԍ擾
	 * 
	 * @return
	 */
	public int getSelectedCellEditorIndex() {
		int defaultIndex = 0;
		CellEditor[] editors = viewer.getCellEditors();
		if (editors == null)
			return -1;
		for (int i = 0; i < editors.length; i++) {
			if (editors[i] != null && editors[i].isActivated()) {
				return i;
			}
		}
		return defaultIndex;
	}

	/**
	 * ҏW\Ȏ̗ԍ擾
	 * 
	 * @param cuurentCol
	 * @return
	 */
	public int getEditableNextColumn(int cuurentCol) {
		CellModifier modifier = (CellModifier) viewer.getCellModifier();
		int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 1;
		if (modifier.canModify(getHeaderTableElement(), String.valueOf(nextCol))) {
			return nextCol;
		} else {
			return getEditableNextColumn(nextCol);
		}
	}

	/**
	 * ҏW\ȑO̗ԍ擾
	 * 
	 * @param CurrentCol
	 * @return
	 */
	public int getEditablePrevColumn(int CurrentCol) {
		CellModifier modifier = (CellModifier) viewer.getCellModifier();
		int nextCol = (CurrentCol == 1) ? table.getColumnCount() - 1 : CurrentCol - 1;
		if (modifier.canModify(getHeaderTableElement(), String.valueOf(nextCol))) {
			return nextCol;
		} else {
			return getEditablePrevColumn(nextCol);
		}
	}

	/**
	 * e[ũwb_vf擾
	 * 
	 * @return
	 */
	public TableElement getHeaderTableElement() {
		Object obj = viewer.getInput();
		if (obj instanceof TableElement[]) {
			TableElement[] elements = (TableElement[]) obj;
			if (elements.length > 0) {
				return elements[0];
			} else {
				return null;
			}
		} else {
			return null;
		}
	}

	/**
	 * w肵JҏW[hɂ
	 * 
	 * @param rowIndex
	 *            sԍ
	 * @param columnIndex
	 *            ԍ
	 */
	public void editTableElement(int rowIndex, int columnIndex) {
//		System.out.println("wJҏC[hɂ܂");
		Object element = viewer.getElementAt(rowIndex);
		if (element != null) {

			// ܂XN[ĕҏW[hɂȂȂ
			// viewer.editElement(element, columnIndex);
			// table.showColumn(table.getColumn(columnIndex));

			// ԓꂩ邱ƂŁA܂XN[{ҏW[hɂȂ
			table.showColumn(table.getColumn(columnIndex));
			viewer.editElement(element, columnIndex);

		}
	}

	/**
	 * ʏ̃JXV f[^x[Xւ̍XV͍sȂi܂łڏj
	 * 
	 */
	public void updateColumn(TableElement element, int col, Object newValue) {
//		System.out.println(" ڂXV܂ ");
		
		// TableElement̒lXVAҏWς݃Xgɒǉ
		element.updateItems(col - 1, newValue);// row-1
		// e[uEr[XV
		viewer.update(element, null);
		columnsPack();

	}

	/**
	 * ̓`FbNэXVf[^TableElementɓo^
	 * 
	 * @param row
	 * @param col
	 * @return
	 */
	public boolean validate(int row, int col) {
		TableElement element = (TableElement) viewer.getElementAt(row);
		Object newValue = null;
		CellEditor editor = viewer.getCellEditors()[col];
		if (editor == null)
			throw new IllegalStateException("CellEditorݒ肳Ă܂"); //$NON-NLS-1$

		if (editor instanceof TextCellEditor) {
			newValue = ((TextCellEditor) editor).getInputValue();
		}
		Object oldValue = element.getItems()[col - 1];// row index-1 Jԍ

		if (!oldValue.equals(newValue)) {
			String msg = editor.getErrorMessage();
			if (msg == null) {
				// ڍXV
				updateColumn(element, col, newValue);
				return true; // 

			} else {
				// ҏWLZ(modifyĂ΂Ȃ悤ɂ)
				viewer.cancelEditing();
				// G[bZ[W\
				setMessage("Input Check:" + msg); //$NON-NLS-1$
				// ͌̃JҏWԂɂ
				editTableElement(row, col);
				return false; // s
			}

		}
		return true;

	}

	public void setMessage(String msg) {
		DbPlugin.getDefault().showWarningMessage(msg);
		// DbPlugin.getActiveTableViewEditor().setStatusErrorMessage(msg);
	}

	/**
	 * Rowԍ̃JPack
	 */
	private void columnsPack() {
/*
		table.setVisible(false);

		TableColumn[] cols = table.getColumns();
		cols[0].pack();

		table.setVisible(true);
*/
	}

	public boolean validateAll() {
		// log.debug("validateAll");
		try {
			int row = getSelectedRow();

			if (row == -1) {
				;// CTRL+C̏ꍇ͂
			} else {
				TableElement element = (TableElement) viewer.getElementAt(row);
				IDBConfig config = element.getTable().getDbConfig();
				IValidatorFactory factory = AbstractValidatorFactory.getFactory(config);
				zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
				String msg = null;
				for (int col = 0; col < columns.length; col++) {
					Object[] items = element.getItems();
					msg = factory.validate(columns[col], items[col]);
					if (msg != null) {
						viewer.cancelEditing();
						setMessage(msg);
						editTableElement(row, col + 1); // rowǉ
						return false;
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
			DbPlugin.getDefault().showErrorDialog(e);
		}
		return true;
	}

	public boolean updateDataBase(TableElement element) throws Exception {
		try {
			TimeWatcher tw = new TimeWatcher();
			tw.start();
			Display display = Display.getDefault();
			// f[^x[XXVtOOFFɂ
			element.setUpdatedDataBase(false);
			
			if (element.isNew()) {
				if (validateAll()) {					
					display.syncExec(new RecordUpdateThread(editor, element));
					
					// Rowԍ̃JPack
					columnsPack();

				} else {
					return false;
				}

			} else if (element.isModify()) {
				// log.debug("UPDATEs");
				if (validateAll()) {
					
					display.syncExec(new RecordUpdateThread(editor, element));

				} else {
					return false;
				}
			} else {
				;
			}
			// f[^x[XXVARs[\ɂ邽߂ɑIԂɂAListener֒ʒm
			viewer.getTable().select(getSelectedRow());	// CsɃtH[JX𓖂Ă
			viewer.getControl().notifyListeners(SWT.Selection, null);

			tw.stop();
			System.out.println("Ŝ̍XV " + tw.getTotalTime());
			
			// f[^x[XXVtOONɂ
			element.setUpdatedDataBase(true);
			
			return true;

		} catch (ZeroUpdateException e) {
			return false;
		} catch (UpdateException e) {
			return false;
		}

	}

	/**
	 * e[uɐVKo^p̃R[h\
	 * 
	 */
	public void createNewRecord() {

		String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString(PreferencePage.P_NULL_SYMBOL);

		TableElement elem = getHeaderTableElement();
		ITable tbl = elem.getTable();
		int count = table.getItems().length;

		// NewRecord̏l
		Object[] items = new Object[elem.getColumns().length];
		for (int i = 0; i < items.length; i++) {
			zigen.plugin.db.core.TableColumn column = elem.getColumns()[i];
			items[i] = InsertRecordAction.getDefaultValue(column);
		}

		TableElement newElement = new TableNewElement(tbl, count + 1, elem.getColumns(), items, elem.getUniqueColumns());

		// R[h̒ǉ
		TableViewerManager.insert(viewer, newElement);

		// PJ(RoẃjҏW
		editTableElement(count, 1); // ŏIR[h1JڂҏW

	}

	/**
	 * ʏ̐VKpR[h폜 f[^x[Xւ̍폜͍sȂi܂łڏj
	 * 
	 */
	public void removeRecord(TableElement element) {
		TableViewerManager.remove(viewer, element);
	}

	/**
	 * RlNV̊J
	 */
	public void dispose() {
		// trans.cloesConnection();
	}

	public void createNewRecord(Object[] items) throws Exception {
		// String nullSymbol =
		// DbPlugin.getDefault().getPreferenceStore().getString(PreferencePage.P_NULL_SYMBOL);
		TableElement elem = getHeaderTableElement();
		ITable tbl = elem.getTable();
		int count = table.getItems().length;
		TableElement newElement = new TableNewElement(tbl, count + 1, elem.getColumns(), items, elem.getUniqueColumns());
		// R[h̒ǉ
		TableViewerManager.insert(viewer, newElement);

		// CJƂĐݒ肷
		for (int i = 0; i < items.length; i++) {
			newElement.addMofiedColumn(i);
		}

		// IsύXĂ 2007-09-06 ZIGEN
		table.setSelection(count);

		// XV 2007-06-19 ZIGEN
		updateDataBase(newElement);

		// PJ(RoẃjҏW
		editTableElement(count, 1); // ŏIR[h1JڂҏW

	}

}
