/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import zigen.plugin.db.core.IDBConfig;

public class SQLHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date date;
    private String sql;
    private boolean isBlank;
    private IDBConfig config;
    private boolean fileMode = false;
    protected SimpleDateFormat ymdFormat = new SimpleDateFormat("yyyyMMdd");
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");

    public SQLHistory() {
        this.sql = "";
        this.date = Calendar.getInstance().getTime();
    }

    public SQLHistory(IDBConfig config, String sql) {
        this.date = Calendar.getInstance().getTime();
        this.config = config;
        this.sql = sql;
    }

    public SQLHistory(boolean isBlank) {
        this.date = Calendar.getInstance().getTime();
        this.sql = "";
        this.isBlank = isBlank;
        this.fileMode = true;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public Date getDate() {
        return this.date;
    }

    public String getSql() {
        return this.sql;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SQLHistory:");
        buffer.append(" date: ");
        buffer.append(this.date);
        buffer.append(" sql: ");
        buffer.append(this.sql);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SQLHistory castedObj = (SQLHistory)o;
        return (this.date == null ? castedObj.date == null : this.date.equals(castedObj.date)) && (this.sql == null ? castedObj.sql == null : this.sql.equals(castedObj.sql)) && this.isBlank == castedObj.isBlank;
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public void setConfig(IDBConfig config) {
        this.config = config;
    }

    public String getFolderName() {
        return this.ymdFormat.format(this.getDate());
    }

    public String getFileName() {
        return this.timeFormat.format(this.getDate());
    }

    public boolean isFileMode() {
        return this.fileMode;
    }

    public void setFileMode(boolean fileMode) {
        this.fileMode = fileMode;
    }
}

