/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;

public class SchemaSearcher {
    public static String[] execute(IDBConfig config) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return SchemaSearcher.execute(con);
    }

    public static String[] execute(Connection con) throws Exception {
        String[] stringArray;
        DatabaseMetaData objMet;
        Statement st;
        ResultSet rs;
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            rs = null;
            st = null;
            objMet = con.getMetaData();
            if (SchemaSearcher.isSupport(con)) break block8;
            String[] stringArray2 = new String[]{};
            Object var7_8 = null;
            StatementUtil.close(st);
            ResultSetUtil.close(rs);
            return stringArray2;
        }
        try {
            list = new ArrayList();
            String s = SchemaSearcher.getSchemaSearchSql(con);
            if (s != null) {
                st = con.createStatement();
                rs = st.executeQuery(s);
            } else {
                rs = objMet.getSchemas();
            }
            while (rs.next()) {
                String wk = rs.getString(1);
                list.add(wk);
            }
            stringArray = list.toArray(new String[0]);
            Object var7_9 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return stringArray;
    }

    private static String getSchemaSearchSql(Connection con) {
        DatabaseMetaData objMet;
        block4: {
            try {
                objMet = con.getMetaData();
                if (DBType.getType(objMet) != 2 || objMet.getDatabaseMajorVersion() < 5) break block4;
                return "SELECT SCHEMA_NAME AS TABLE_SCHEM FROM information_schema.SCHEMATA";
            }
            catch (SQLException sQLException) {}
        }
        if (DBType.getType(objMet) == 3) {
            String dbName = ConnectionManager.getDBName(con);
            return "SELECT TRIM(SCHEMA_NAME) AS TABLE_SCHEM FROM RDBII_SYSTEM.RDBII_SCHEMA WHERE DB_NAME = '" + dbName + "'";
        }
        return null;
    }

    public static boolean isSupport(Connection con) {
        DatabaseMetaData objMet;
        block3: {
            try {
                objMet = con.getMetaData();
                if (DBType.getType(objMet) != 2 || objMet.getDatabaseMajorVersion() < 5) break block3;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return objMet.supportsSchemasInTableDefinitions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void existSchemaName(Connection con, String target) throws SQLException {
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            if (!SchemaSearcher.isSupport(con)) {
            } else {
                String wk;
                String s = SchemaSearcher.getSchemaSearchSql(con);
                if (s != null) {
                    st = con.createStatement();
                    rs = st.executeQuery(s);
                } else {
                    rs = objMet.getSchemas();
                }
                do {
                    if (rs.next()) continue;
                    if (s == null) throw new SQLException("The schema doesn't exist.");
                    throw new SQLException("The schema doesn't exist.\n" + s);
                } while (!(wk = rs.getString(1)).equalsIgnoreCase(target));
            }
            Object var7_5 = null;
            StatementUtil.close(st);
            ResultSetUtil.close(rs);
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            StatementUtil.close(st);
            ResultSetUtil.close(rs);
            throw throwable;
        }
    }
}

