/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.rule.AbstractTableInfoSearchFactory;
import zigen.plugin.db.core.rule.ColumnInfo;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.ITableInfoSearchFactory;
import zigen.plugin.db.core.rule.mysql.MySQLColumnSearcharFactory;
import zigen.plugin.db.core.rule.oracle.OracleColumnSearcharFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareColumnSearcharFactory;

public abstract class AbstractColumnSearcherFactory
implements IColumnSearcherFactory {
    public static final String COLUMN_NAME_STR = "COLUMN_NAME";
    public static final String DATA_TYPE_STR = "DATA_TYPE";
    public static final String TYPE_NAME_STR = "TYPE_NAME";
    public static final String DATA_PRECISION_STR = "DATA_PRECISION";
    public static final String DATA_SCALE_STR = "DATA_SCALE";
    public static final String DATA_DEFAULT_STR = "DATA_DEFAULT";
    public static final String NULLABLE_STR = "NULLABLE";
    public static final String COMMENTS_STR = "COMMENTS";
    private static Map map = new HashMap();

    public static IColumnSearcherFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
        IColumnSearcherFactory factory = null;
        String driverName = "";
        try {
            driverName = objMet.getDriverName();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new DefaultColumnSearcherFactory(objMet, isConvertUnicode);
        }
        String key = String.valueOf(driverName) + ":" + isConvertUnicode;
        if (map.containsKey(key)) {
            factory = (IColumnSearcherFactory)map.get(key);
            factory.setConvertUnicode(isConvertUnicode);
            factory.setDatabaseMetaData(objMet);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleColumnSearcharFactory(objMet, isConvertUnicode);
                    break;
                }
                case 2: {
                    factory = new MySQLColumnSearcharFactory(objMet, isConvertUnicode);
                    break;
                }
                case 3: {
                    factory = new SymfowareColumnSearcharFactory(objMet, isConvertUnicode);
                    break;
                }
                default: {
                    factory = new DefaultColumnSearcherFactory(objMet, isConvertUnicode);
                }
            }
            map.put(key, factory);
        }
        return factory;
    }

    protected abstract String getCustomColumnInfoSQL(String var1, String var2, String var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getCustomColumnInfoMap(Connection con, String owner, String table, boolean convertUnicode) throws Exception {
        Statement st;
        ResultSet rs;
        HashMap<String, ColumnInfo> map;
        block9: {
            HashMap<String, ColumnInfo> hashMap;
            block8: {
                map = new HashMap<String, ColumnInfo>();
                rs = null;
                st = null;
                try {
                    try {
                        ITableInfoSearchFactory factory = AbstractTableInfoSearchFactory.getFactory(con.getMetaData());
                        String dbName = factory.getDbName();
                        String sql = this.getCustomColumnInfoSQL(dbName, owner, table);
                        if (sql == null) {
                            hashMap = map;
                            Object var12_13 = null;
                            break block8;
                        }
                        st = con.createStatement();
                        rs = st.executeQuery(sql);
                        while (rs.next()) {
                            ColumnInfo info = new ColumnInfo();
                            info.setColumn_name(rs.getString(COLUMN_NAME_STR));
                            info.setData_type(rs.getString(DATA_TYPE_STR));
                            info.setData_precision(rs.getBigDecimal(DATA_PRECISION_STR));
                            info.setData_scale(rs.getBigDecimal(DATA_SCALE_STR));
                            info.setData_default(rs.getString(DATA_DEFAULT_STR));
                            info.setComments(rs.getString(COMMENTS_STR));
                            if (convertUnicode) {
                                info.setColumn_name(JDBCUnicodeConvertor.convert(info.getColumn_name()));
                                info.setData_type(JDBCUnicodeConvertor.convert(info.getData_type()));
                                info.setData_default(JDBCUnicodeConvertor.convert(info.getData_default()));
                                info.setComments(JDBCUnicodeConvertor.convert(info.getComments()));
                            }
                            map.put(info.getColumn_name(), info);
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        DbPlugin.log(e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    ResultSetUtil.close(rs);
                    StatementUtil.close(st);
                    throw throwable;
                }
            }
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            return hashMap;
        }
        Object var12_15 = null;
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return map;
    }
}

