/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultValidatorFactory;
import zigen.plugin.db.core.rule.IValidatorFactory;
import zigen.plugin.db.core.rule.Messages;
import zigen.plugin.db.core.rule.UnSupportedTypeException;
import zigen.plugin.db.core.rule.derby.DerbyValidatorFactory;
import zigen.plugin.db.core.rule.mysql.MySQLValidatorFactory;
import zigen.plugin.db.core.rule.oracle.OracleValidatorFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareValidatorFactory;

public abstract class AbstractValidatorFactory
implements IValidatorFactory {
    String nullSymbol;
    private static Map map = new HashMap();

    public static IValidatorFactory getFactory(IDBConfig config) {
        return AbstractValidatorFactory.getFactory(config.getDriverName());
    }

    public static IValidatorFactory getFactory(DatabaseMetaData objMet) {
        try {
            return AbstractValidatorFactory.getFactory(objMet.getDriverName());
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Failed get DriverName");
        }
    }

    private static IValidatorFactory getFactory(String driverName) {
        IValidatorFactory factory = null;
        String key = driverName;
        if (map.containsKey(key)) {
            factory = (IValidatorFactory)map.get(key);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleValidatorFactory();
                    break;
                }
                case 3: {
                    factory = new SymfowareValidatorFactory();
                    break;
                }
                case 2: {
                    factory = new MySQLValidatorFactory();
                    break;
                }
                case 6: {
                    factory = new DerbyValidatorFactory();
                    break;
                }
                default: {
                    factory = new DefaultValidatorFactory();
                }
            }
            map.put(key, factory);
        }
        factory.setNullSymbol(DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol"));
        return factory;
    }

    public String validate(TableColumn column, Object value) throws UnSupportedTypeException {
        String columnName = column.getColumnName();
        if (this.nullSymbol.equals(value)) {
            if (column.isNotNull()) {
                return String.valueOf(columnName) + Messages.getString("AbstractValidatorFactory.0");
            }
            return null;
        }
        return this.validateDataType(column, value);
    }

    public String getNullSymbol() {
        return this.nullSymbol;
    }

    public void setNullSymbol(String nullSymbol) {
        this.nullSymbol = nullSymbol;
    }

    abstract String validateDataType(TableColumn var1, Object var2) throws UnSupportedTypeException;
}

