/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;
import zigen.plugin.db.ui.editors.TableViewEditorInput;
import zigen.plugin.db.ui.editors.sql.SequenceEditorInput;
import zigen.plugin.db.ui.editors.sql.SourceEditorInput;
import zigen.plugin.db.ui.internal.DataBase;

public class CloseDBAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public CloseDBAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("CloseDBAction.0"));
        this.setToolTipText(Messages.getString("CloseDBAction.1"));
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof DataBase)) continue;
            DataBase db = (DataBase)element;
            this.closeDataBase(db);
            DbPlugin.fireStatusChangeListener(db.getDbConfig(), 201);
        }
    }

    private void closeDataBase(DataBase db) {
        try {
            Transaction trans = Transaction.getInstance(db.getDbConfig());
            trans.cloesConnection();
            TransactionForTableEditor trans2 = TransactionForTableEditor.getInstance(db.getDbConfig());
            trans2.cloesConnection();
            this.viewer.getControl().notifyListeners(13, null);
            db.removeChildAll();
            db.setConnected(false);
            db.setExpanded(false);
            this.viewer.collapseToLevel((Object)db, 1);
            this.viewer.refresh((Object)db);
            ArrayList<IEditorReference> target = new ArrayList<IEditorReference>();
            IEditorReference[] references = DbPlugin.getDefault().getPage().getEditorReferences();
            int i = 0;
            while (i < references.length) {
                IDBConfig config;
                IEditorReference reference = references[i];
                IEditorInput input = reference.getEditorInput();
                if (input instanceof QueryViewEditorInput) {
                    config = ((QueryViewEditorInput)input).getConfig();
                    if (config.getDbName().equals(db.getName())) {
                        target.add(reference);
                    }
                } else if (input instanceof TableViewEditorInput) {
                    config = ((TableViewEditorInput)input).getConfig();
                    if (config.getDbName().equals(db.getName())) {
                        target.add(reference);
                    }
                } else if (input instanceof SequenceEditorInput) {
                    config = ((SequenceEditorInput)input).getConfig();
                    if (config.getDbName().equals(db.getName())) {
                        target.add(reference);
                    }
                } else if (input instanceof SourceEditorInput && (config = ((SourceEditorInput)input).getConfig()).getDbName().equals(db.getName())) {
                    target.add(reference);
                }
                ++i;
            }
            if (target.size() > 0) {
                DbPlugin.getCloseEditors(target.toArray(new IEditorReference[0]));
            }
            if (DBType.getType(db.getDbConfig()) == 6) {
                this.shutdown(db.getDbConfig());
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void shutdown(IDBConfig config) {
        try {
            ConnectionManager.shutdown(config);
        }
        catch (SQLException e) {
            if (DBType.getType(config) == 6 && e.getErrorCode() == 50000) {
                DbPlugin.getDefault().showInformationMessage(e.getMessage());
                return;
            }
            DbPlugin.getDefault().showErrorDialog(e);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

