/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.io.File;
import java.util.NoSuchElementException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.XMLManager;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.wizard.ImpDBConfigWizard;

public class ImportDBConfigAction
extends Action
implements Runnable {
    TreeViewer viewer;

    public ImportDBConfigAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("ImportDBConfigAction.0"));
        this.setToolTipText(Messages.getString("ImportDBConfigAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("import.gif"));
    }

    public void run() {
        try {
            Shell shell = DbPlugin.getDefault().getShell();
            File file = this.save(shell, null);
            if (file != null) {
                Object xml = this.loadXml(file);
                if (xml instanceof IDBConfig[]) {
                    IDBConfig[] configs = (IDBConfig[])xml;
                    ImpDBConfigWizard wizard = new ImpDBConfigWizard(this.viewer, configs);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                    DbPlugin.fireStatusChangeListener(this.viewer, 107);
                } else {
                    DbPlugin.getDefault().showWarningMessage(Messages.getString("ImportDBConfigAction.3"));
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private Object loadXml(File file) throws Exception {
        try {
            return XMLManager.load(file);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Exception(Messages.getString("ImportDBConfigAction.4"));
        }
    }

    private File save(Shell shell, String defaultFileName) {
        FileDialog dialog = new FileDialog(shell, 16384);
        dialog.setFileName(defaultFileName);
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setFilterNames(new String[]{Messages.getString("ImportDBConfigAction.7"), Messages.getString("ImportDBConfigAction.8")});
        String fileName = dialog.open();
        if (fileName != null) {
            return new File(fileName);
        }
        return null;
    }
}

