/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;

public class TableEditorLogUtil {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void successLog(String str) {
        StringBuffer log = new StringBuffer();
        log.append(TableEditorLogUtil.getSystemDate());
        log.append(" [OK] ");
        log.append(str);
        TableEditorLogUtil.write(log.toString());
    }

    public static void failureLog(String str) {
        StringBuffer log = new StringBuffer();
        log.append(TableEditorLogUtil.getSystemDate());
        log.append(" [NG] ");
        log.append(str);
        TableEditorLogUtil.write(log.toString());
    }

    public static void debugLog(String str) {
        StringBuffer log = new StringBuffer();
        log.append(TableEditorLogUtil.getSystemDate());
        log.append(" [DEBUG] ");
        log.append(str);
        TableEditorLogUtil.write(log.toString());
    }

    private static void write(String log) {
        IDocument doc;
        ITableViewEditor editor = DbPlugin.getActiveTableViewEditor();
        if (editor != null && editor instanceof TableViewEditorFor31 && (doc = ((TableViewEditorFor31)editor).getLogViewer().getDocument()) != null) {
            String pre = doc.get();
            if (pre.length() == 0) {
                doc.set(log);
            } else {
                doc.set(String.valueOf(pre) + LINE_SEP + log);
            }
        }
    }

    private static String getSystemDate() {
        Calendar cal = Calendar.getInstance();
        return format.format(cal.getTime());
    }
}

