/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import java.sql.SQLException;
import org.eclipse.jface.wizard.Wizard;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.wizard.ConfirmDDLWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.IConfirmDDLWizard;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.ITable;

public abstract class DefaultWizard
extends Wizard
implements IConfirmDDLWizard {
    protected ConfirmDDLWizardPage confirmPage;
    protected ISQLCreatorFactory factory;
    protected ITable tableNode;
    protected IDBConfig config;

    public DefaultWizard(ISQLCreatorFactory factory, ITable tableNode) {
        this.factory = factory;
        this.tableNode = tableNode;
        this.config = tableNode.getDbConfig();
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
        this.confirmPage = new ConfirmDDLWizardPage();
    }

    public boolean performFinish() {
        try {
            this.confirmPage.generateSQL();
            int rowAffected = 0;
            String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
            String sqlString = this.confirmPage.getDocument().get();
            Transaction trans = Transaction.getInstance(this.config);
            SQLTokenizer tokenizer = new SQLTokenizer(sqlString, demiliter);
            while (tokenizer.hasMoreElements()) {
                String sql = tokenizer.nextToken();
                if (sql == null || sql.length() <= 0) continue;
                rowAffected += SQLInvoker.executeUpdate(trans.getConnection(), sql);
            }
            if (!this.config.isAutoCommit() && this.factory.supportsRollbackDDL() && DbPlugin.getDefault().confirmDialog(Messages.getString("DefaultWizard.0"))) {
                trans.commit();
            }
            DbPlugin.fireStatusChangeListener(this.tableNode, 103);
            return true;
        }
        catch (SQLException e) {
            DbPlugin.getDefault().showWarningMessage(e.getMessage());
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return false;
    }

    public abstract String[] createSQL() throws Exception;

    public ConfirmDDLWizardPage getConfirmDDLWizardPage() {
        return this.confirmPage;
    }
}

