/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.core.ColumnSeqSorter;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.wizard.FKWizard;
import zigen.plugin.db.ui.editors.internal.wizard.FKWizardPage1;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.editors.internal.wizard.PKWizardPage;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class FKWizardPage2
extends PKWizardPage {
    public static final String MSG_DSC = Messages.getString("FKWizardPage2.0");
    private static final String MSG_REQUIRE_TABLE = Messages.getString("FKWizardPage2.1");
    private static final String MSG_REQUIRE_COLUMN = Messages.getString("FKWizardPage2.2");
    private static final String MSG_OVER_COLUMN = Messages.getString("FKWizardPage2.3");
    protected IDBConfig config;
    protected Text targetTxt;
    protected Combo comboRefTable;
    protected Button chkDeleteCascade;
    protected List refTableList = new ArrayList();

    public FKWizardPage2(ISQLCreatorFactory factory, ITable table) {
        super(factory, table);
        this.setTitle(Messages.getString("FKWizardPage2.4"));
        this.config = table.getDbConfig();
        this.setPageComplete(false);
        this.columnList = new ArrayList();
        this.createTableList();
    }

    protected void createTableList() {
        try {
            Connection con = Transaction.getInstance(this.config).getConnection();
            TableInfo[] tables = TableSearcher.execute(con, this.tableNode.getSchemaName(), new String[]{"TABLE"});
            int i = 0;
            while (i < tables.length) {
                TableInfo info = tables[i];
                this.refTableList.add(info);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createColumnList(String tableName) {
        try {
            Connection con = Transaction.getInstance(this.config).getConnection();
            IDBConfig config = this.tableNode.getDbConfig();
            IColumnSearcherFactory factory = DefaultColumnSearcherFactory.getFactory(con.getMetaData(), config.isConvertUnicode());
            TableColumn[] columns = factory.execute(con, this.tableNode.getSchemaName(), tableName);
            this.columnList = new ArrayList();
            int i = 0;
            while (i < columns.length) {
                Column column = new Column();
                column.setColumn(columns[i]);
                this.columnList.add(column);
                ++i;
            }
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected FKWizardPage1 getFKWizardPage1() {
        IWizardPage page = this.getPreviousPage();
        if (page instanceof FKWizardPage1) {
            return (FKWizardPage1)page;
        }
        return null;
    }

    protected void createNameConstrol(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label0 = new Label(composite, 0);
        label0.setText(Messages.getString("FKWizardPage2.6"));
        this.targetTxt = new Text(composite, 2048);
        this.targetTxt.setText("");
        this.targetTxt.setEnabled(false);
        GridData gd = new GridData(768);
        this.targetTxt.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("FKWizardPage2.8"));
        this.comboRefTable = new Combo(composite, 2056);
        gd = new GridData(768);
        this.comboRefTable.setLayoutData((Object)gd);
        Iterator iter = this.refTableList.iterator();
        while (iter.hasNext()) {
            TableInfo w_table = (TableInfo)iter.next();
            if (w_table.getComment() != null && !"".equals(w_table.getComment())) {
                this.comboRefTable.add(String.valueOf(w_table.getName()) + " [" + w_table.getComment() + "]");
                continue;
            }
            this.comboRefTable.add(w_table.getName());
        }
        this.comboRefTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = FKWizardPage2.this.comboRefTable.getSelectionIndex();
                TableInfo tableInfo = (TableInfo)FKWizardPage2.this.refTableList.get(index);
                FKWizardPage2.this.createColumnList(tableInfo.getName());
                FKWizardPage2.this.selectColumnViewer.setInput(null);
            }
        });
    }

    protected void createOptionControl(Composite container) {
        this.chkDeleteCascade = new Button(container, 32);
        this.chkDeleteCascade.setText(Messages.getString("FKWizardPage2.12"));
        GridData gd = new GridData(768);
        this.chkDeleteCascade.setLayoutData((Object)gd);
        this.chkDeleteCascade.setSelection(true);
    }

    protected void update() {
        Collections.sort(this.columnList, new ColumnSeqSorter());
        this.selectColumnViewer.setInput((Object)this.selectedList.toArray(new Column[0]));
        this.columnViewer.setInput((Object)this.columnList.toArray(new Column[0]));
        this.columnsPack(this.selectColumnViewer.getTable());
        this.columnsPack(this.columnViewer.getTable());
        if (this.columnList.size() == 0 && this.selectedList.size() == 0) {
            this.updateStatus(MSG_REQUIRE_TABLE);
        } else if (this.selectedList.size() < this.getFKWizardPage1().getTargetColumnCount()) {
            this.updateStatus(MSG_REQUIRE_COLUMN);
        } else if (this.selectedList.size() > this.getFKWizardPage1().getTargetColumnCount()) {
            this.updateStatus(MSG_OVER_COLUMN);
        } else {
            this.updateStatus(null);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            FKWizard wiz = (FKWizard)this.getWizard();
            IWizardPage page = wiz.getPreviousPage((IWizardPage)this);
            if (page instanceof FKWizardPage1) {
                FKWizardPage1 page1 = (FKWizardPage1)page;
                this.targetTxt.setText(page1.getTargetColumn());
            }
            this.setDescription(MSG_DSC);
            this.update();
        }
    }

    public TableInfo getRerenceTableInfo() {
        int index = this.comboRefTable.getSelectionIndex();
        return (TableInfo)this.refTableList.get(index);
    }
}

