/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Messages;
import zigen.plugin.db.ui.internal.Table;

public class Synonym
extends Table
implements ITable {
    private static final long serialVersionUID = 1L;
    private SynonymInfo synonymInfo;

    public Synonym(String name, String remarks) {
        super(name, remarks);
    }

    public Synonym(String name) {
        super(name);
    }

    public Synonym() {
    }

    public void update(Synonym node) {
        super.update(node);
        this.synonymInfo = node.synonymInfo;
    }

    public SynonymInfo getSynonymInfo() {
        return this.synonymInfo;
    }

    public void setSynonymInfo(SynonymInfo synonymInfo) {
        this.synonymInfo = synonymInfo;
        if (synonymInfo != null) {
            this.setRemarks(synonymInfo.getComments());
        }
    }

    public String getRemarks() {
        if (this.synonymInfo != null) {
            String commenet = this.synonymInfo.getComments();
            return commenet == null ? "" : commenet;
        }
        return "";
    }

    public void setRemarks(String remarks) {
        if (this.synonymInfo != null) {
            this.synonymInfo.setComments(remarks);
        }
    }

    public String getDb_link() {
        if (this.synonymInfo != null) {
            return this.synonymInfo.getDb_link();
        }
        return null;
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.getRemarks() != null && this.getRemarks().length() > 0) {
            sb.append(" [");
            sb.append(this.getRemarks());
            sb.append("]");
        }
        return sb.toString();
    }

    public String getTable_name() throws Exception {
        if (this.synonymInfo != null) {
            return this.synonymInfo.getTable_name();
        }
        throw new NotFoundSynonymInfoException(Messages.getString("Synonym.4"));
    }

    public String getTable_owner() throws Exception {
        if (this.synonymInfo != null) {
            return this.synonymInfo.getTable_owner();
        }
        throw new NotFoundSynonymInfoException(Messages.getString("Synonym.5"));
    }
}

