/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;

public class RecordSearchJob
extends AbstractJob {
    public static final String JOB_NAME;
    private TableViewEditorFor31 editor;
    private String condition;
    private String orderBy;
    private int offset;
    private int limit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("zigen.plugin.db.ui.jobs.RecordSearchJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JOB_NAME = clazz.getName();
    }

    public RecordSearchJob(TableViewEditorFor31 editor, String condition, String orderBy, int offset, int limit) {
        super(Messages.getString("RecordSearchJob.0"));
        this.editor = editor;
        this.condition = condition;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TableElement[] elements = null;
        TimeWatcher time = new TimeWatcher();
        time.start();
        try {
            ITable table = this.editor.getTableNode();
            elements = this.orderBy != null ? (this.condition == null ? TableManager.invoke(table.getDbConfig(), table, this.orderBy, this.offset, this.limit) : TableManager.invoke(table.getDbConfig(), table, String.valueOf(this.condition) + " " + this.orderBy, this.offset, this.limit)) : TableManager.invoke(table.getDbConfig(), table, this.condition);
            time.stop();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.limit == 0) {
                this.showResults(new ShowResultAction(this.condition, elements, time.getTotalTime(), false));
            } else {
                IDBConfig config = table.getDbConfig();
                ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, table);
                if (factory.isSupportPager()) {
                    this.showResults(new ShowResultAction(this.condition, elements, time.getTotalTime(), true));
                } else {
                    this.showResults(new ShowResultAction(this.condition, elements, time.getTotalTime(), false));
                }
            }
        }
        catch (MaxRecordException e) {
            time.stop();
            elements = e.getTableElements();
            this.showResults(new ShowResultAction(this.condition, elements, time.getTotalTime(), e.getMessage(), true));
        }
        catch (SQLException e) {
            this.showWarningMessage(e.getMessage());
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("RecordSearchJob.1"), e);
        }
        return Status.OK_STATUS;
    }

    protected class ShowResultAction
    implements Runnable {
        String condition = null;
        TableElement[] elements = null;
        String responseTime = null;
        String message = null;
        boolean doCalculate;

        public ShowResultAction(String condition, TableElement[] elements, String responseTime, String message, boolean doCalculate) {
            this.condition = condition;
            this.elements = elements;
            this.responseTime = responseTime;
            this.message = message;
            this.doCalculate = doCalculate;
        }

        public ShowResultAction(String condition, TableElement[] elements, String responseTime, boolean doCalculate) {
            this(condition, elements, responseTime, "", doCalculate);
        }

        public void run() {
            try {
                RecordSearchJob.this.editor.updateTableViewer(this.condition, this.elements, this.responseTime, this.doCalculate);
                RecordSearchJob.this.editor.setInfomationText(this.message);
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

