/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.Messages;

public class ImageCacher {
    private static ImageCacher instance;
    private Map map = new HashMap();

    public static synchronized ImageCacher getInstance() {
        if (instance == null) {
            instance = new ImageCacher();
        }
        return instance;
    }

    private ImageCacher() {
    }

    public Image getImage(String imageCode) {
        if (this.map.containsKey(imageCode)) {
            return (Image)this.map.get(imageCode);
        }
        this.createImage(imageCode);
        return this.getImage(imageCode);
    }

    private void createImage(String imageCode) {
        DbPlugin plugin = DbPlugin.getDefault();
        ImageDescriptor id = plugin.getImageDescriptor(imageCode);
        if (id != null) {
            this.map.put(imageCode, id.createImage());
        } else {
            DbPlugin.log(String.valueOf(Messages.getString("ImageCacher.Error")) + imageCode);
        }
    }

    public void clear() {
        this.map = null;
    }
}

