/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import blanco.commons.sql.format.BlancoSqlFormatter;
import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlRule;
import kry.sql.format.ISqlFormatRule;
import kry.sql.format.SqlFormat;
import kry.sql.format.SqlFormatException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatterPach;
import zigen.plugin.db.core.SqlStreamTokenizer;
import zigen.plugin.db.core.StringUtil;

public class SQLFormatter {
    public static String format(String preSql, int formatterType, boolean onPatch, int offset) {
        if (formatterType == 0) {
            try {
                SqlFormat formatter = new SqlFormat((ISqlFormatRule)DbPlugin.getSqlFormatRult());
                return formatter.format(preSql, offset);
            }
            catch (SqlFormatException e) {
                DbPlugin.getDefault();
                DbPlugin.log(e);
                return preSql;
            }
        }
        try {
            BlancoSqlFormatter formatter = new BlancoSqlFormatter(new BlancoSqlRule());
            String result = formatter.format(preSql);
            if (onPatch) {
                result = SQLFormatterPach.format(result);
            }
            return StringUtil.convertLineSep(result, DbPluginConstant.LINE_SEP);
        }
        catch (BlancoSqlFormatterException e) {
            DbPlugin.getDefault();
            DbPlugin.log(e);
            return preSql;
        }
    }

    public static String format(String preSql, int formatterType, boolean onPatch) {
        return SQLFormatter.format(preSql, formatterType, onPatch, 0);
    }

    public static String unformat(String sql) {
        SqlFormat formatter = new SqlFormat((ISqlFormatRule)DbPlugin.getSqlFormatRult());
        return formatter.unFormat(sql);
    }

    public static String[] splitOrderCause(String whereCause) {
        String[] result = new String[2];
        StringBuffer main = new StringBuffer();
        StringBuffer order = new StringBuffer();
        if (whereCause == null) {
            result[0] = main.toString();
            result[1] = order.toString();
            return result;
        }
        SqlStreamTokenizer tokenizer = new SqlStreamTokenizer(whereCause);
        boolean isOrderCause = false;
        try {
            String s = null;
            block6: while (true) {
                switch (tokenizer.nextToken()) {
                    case -1: {
                        result[0] = main.toString();
                        result[1] = order.toString();
                        return result;
                    }
                    case 44: {
                        if (isOrderCause) {
                            order = new StringBuffer(order.toString().trim());
                            order.append(',');
                            order.append(' ');
                            continue block6;
                        }
                        main = new StringBuffer(main.toString().trim());
                        main.append(',');
                        main.append(' ');
                        continue block6;
                    }
                }
                s = tokenizer.getToken();
                if (isOrderCause || "order".equalsIgnoreCase(s)) {
                    isOrderCause = true;
                    order.append(s);
                    continue;
                }
                main.append(s);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
            return result;
        }
    }
}

