/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.AbstractValidatorFactory;
import zigen.plugin.db.core.rule.UnSupportedTypeException;
import zigen.plugin.db.core.rule.Validator;

public class DefaultValidatorFactory
extends AbstractValidatorFactory {
    public String validateDataType(TableColumn column, Object value) throws UnSupportedTypeException {
        int type = column.getDataType();
        String columnName = column.getColumnName().toUpperCase();
        switch (type) {
            case 1: {
                return this.validate_CHAR(columnName, (String)value);
            }
            case 12: {
                return this.validate_VARCHAR(columnName, (String)value);
            }
            case -1: {
                return this.validate_LONGVARCHAR(columnName, (String)value);
            }
            case -7: 
            case 16: {
                return this.validate_BIT(columnName, (String)value);
            }
            case -6: {
                return this.validate_TINYINT(columnName, (String)value);
            }
            case 4: {
                return this.validate_INTEGER(columnName, (String)value);
            }
            case 5: {
                return this.validate_SMALLINT(columnName, (String)value);
            }
            case -5: {
                return this.validate_BIGINT(columnName, (String)value);
            }
            case 7: {
                return this.validate_REAL(columnName, (String)value);
            }
            case 6: {
                return this.validate_FLOAT(columnName, (String)value);
            }
            case 8: {
                return this.validate_DOUBLE(columnName, (String)value);
            }
            case 2: {
                return this.validate_NUMERIC(columnName, (String)value);
            }
            case 3: {
                return this.validate_DECIMAL(columnName, (String)value);
            }
            case 91: {
                return this.validate_DATE(columnName, (String)value);
            }
            case 92: {
                return this.validate_TIME(columnName, (String)value);
            }
            case 93: {
                return this.validate_TIMESTAMP(columnName, (String)value);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: 
            case 2005: {
                return null;
            }
        }
        return null;
    }

    protected String validate_CHAR(String columnName, String value) {
        return null;
    }

    protected String validate_VARCHAR(String columnName, String value) {
        return null;
    }

    protected String validate_LONGVARCHAR(String columnName, String value) {
        return null;
    }

    protected String validate_BIT(String columnName, String value) {
        return Validator.boolean_Check(columnName, value);
    }

    protected String validate_TINYINT(String columnName, String value) {
        return Validator.tinyint_Check(columnName, value);
    }

    protected String validate_INTEGER(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_SMALLINT(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_BIGINT(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_REAL(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_FLOAT(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_DOUBLE(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_NUMERIC(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_DECIMAL(String columnName, String value) {
        return Validator.decimal_Check(columnName, value);
    }

    protected String validate_DATE(String columnName, String value) {
        return Validator.date_Check(columnName, value);
    }

    protected String validate_TIME(String columnName, String value) {
        return Validator.time_Check(columnName, value);
    }

    protected String validate_TIMESTAMP(String columnName, String value) {
        return Validator.timestamp_Check(columnName, value);
    }
}

