/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.io.Serializable;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.diff.IDDL;
import zigen.plugin.db.ui.internal.ITable;

public class DDL
implements IDDL,
Serializable {
    private static final long serialVersionUID = 1L;
    boolean isSchemaSupport;
    String dbName;
    String schemaName;
    String targetName;
    String ddl;
    ITable table;

    public DDL() {
    }

    public DDL(ITable table) {
        this.setTable(table);
    }

    private String getDDLString(ITable tableNode) {
        String result = "";
        try {
            if (tableNode != null) {
                IDBConfig config = tableNode.getDbConfig();
                ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactoryNoCache(config, tableNode);
                factory.setVisibleSchemaName(false);
                result = factory.createDDL();
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return result;
    }

    public String getDisplayedName() {
        StringBuffer sb = new StringBuffer();
        if (this.isSchemaSupport) {
            sb.append(String.valueOf(this.schemaName) + "." + this.targetName);
        } else {
            sb.append(this.targetName);
        }
        return sb.toString();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDdl() {
        return this.ddl;
    }

    public void setDdl(String ddl) {
        this.ddl = ddl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String tableName) {
        this.targetName = tableName;
    }

    public boolean isSchemaSupport() {
        return this.isSchemaSupport;
    }

    public void setSchemaSupport(boolean isSchemaSupport) {
        this.isSchemaSupport = isSchemaSupport;
    }

    public String getType() {
        return this.table.getFolderName();
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTable(ITable table) {
        this.table = table;
        this.dbName = table.getDbConfig().getDbName();
        this.schemaName = table.getSchemaName();
        this.targetName = table.getName();
        this.isSchemaSupport = table.getDataBase().isSchemaSupport();
        this.ddl = this.getDDLString(table);
    }
}

