/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleTriggerInfo;

public class OracleTriggerSearcher {
    public static OracleTriggerInfo[] execute(IDBConfig config, String owner, String table) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleTriggerSearcher.execute(con, owner, table);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OracleTriggerInfo[] execute(Connection con, String owner, String table) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        ArrayList<OracleTriggerInfo> list = new ArrayList<OracleTriggerInfo>();
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleTriggerSearcher.getSQL(owner, table));
                while (rs.next()) {
                    OracleTriggerInfo info = new OracleTriggerInfo();
                    info.setOwner(rs.getString("OWNER"));
                    info.setName(rs.getString("TRIGGER_NAME"));
                    info.setType(rs.getString("TRIGGER_TYPE"));
                    info.setEvent(rs.getString("TRIGGERING_EVENT"));
                    list.add(info);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return list.toArray(new OracleTriggerInfo[0]);
    }

    private static String getSQL(String owner, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        OWNER");
        sb.append("        ,TRIGGER_NAME");
        sb.append("        ,TRIGGER_TYPE");
        sb.append("        ,TRIGGERING_EVENT");
        sb.append("    FROM");
        sb.append("        ALL_TRIGGERS");
        sb.append("    WHERE");
        sb.append("        TABLE_OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND TABLE_NAME = '" + SQLUtil.encodeQuotation(table) + "'");
        sb.append("     ORDER BY TRIGGER_NAME");
        return sb.toString();
    }
}

