/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public class CopyCreateStatementAction
implements IViewActionDelegate {
    private ISelection selection = null;
    private IViewPart viewPart;
    TreeViewer treeViewer;
    boolean isSelectedColumn = false;
    StringBuffer sb = null;

    public void init(IViewPart view) {
        this.viewPart = view;
        if (view instanceof TreeView) {
            this.treeViewer = ((TreeView)view).getTreeViewer();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IAction action) {
        try {
            if (!(this.selection instanceof IStructuredSelection)) return;
            IStructuredSelection ss = (IStructuredSelection)this.selection;
            new StringBuffer();
            if (!this.checkLoadColumn(ss)) {
                String msg = Messages.getString("CopyCreateStatementAction.0");
                msg = String.valueOf(msg) + Messages.getString("CopyCreateStatementAction.1");
                if (!DbPlugin.getDefault().confirmDialog(msg)) return;
                new LoadAction((StructuredViewer)this.treeViewer, ss).run();
                return;
            } else {
                new LoadAction((StructuredViewer)this.treeViewer, ss).run();
            }
            return;
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private boolean checkLoadColumn(IStructuredSelection ss) {
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            ITable table;
            Object obj = iter.next();
            if (!(obj instanceof ITable) || (table = (ITable)obj).isExpanded()) continue;
            return false;
        }
        return true;
    }

    private String getCommentStatement(ITable tableNode) {
        StringBuffer sb = new StringBuffer();
        if (tableNode != null) {
            IDBConfig config = tableNode.getDbConfig();
            ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactoryNoCache(config, tableNode);
            factory.setVisibleSchemaName(false);
            sb.append(factory.getTableComment());
            sb.append(factory.getColumnComment());
        }
        return sb.toString();
    }

    void setContents(String contents) {
        Clipboard clipboard = ClipboardUtils.getInstance();
        if (contents.length() > 0) {
            clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    static /* synthetic */ String access$0(CopyCreateStatementAction copyCreateStatementAction, ITable iTable) {
        return copyCreateStatementAction.getCommentStatement(iTable);
    }

    class LoadAction
    extends Action {
        IStructuredSelection ss;
        StructuredViewer viewer;

        public LoadAction(StructuredViewer viewer, IStructuredSelection ss) {
            this.viewer = viewer;
            this.ss = ss;
        }

        public void run() {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(this){
                    final /* synthetic */ LoadAction this$1;
                    {
                        this.this$1 = loadAction;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.getString("CopyCreateStatementAction.2"), this.this$1.ss.size());
                        LoadAction.access$0((LoadAction)this.this$1).sb = new StringBuffer();
                        int i = 1;
                        Iterator iter = this.this$1.ss.iterator();
                        while (iter.hasNext()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            E obj = iter.next();
                            if (obj instanceof ITable) {
                                ITable table = (ITable)obj;
                                monitor.subTask("Target : " + table + ", " + i + "/" + this.this$1.ss.size());
                                if (!table.isExpanded()) {
                                    table.setExpanded(true);
                                    new ColumnSearchAction(this.this$1.viewer, table).run();
                                }
                                LoadAction.access$0((LoadAction)this.this$1).sb.append(CopyCreateStatementAction.access$0(LoadAction.access$0(this.this$1), table));
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                        LoadAction.access$0(this.this$1).setContents(LoadAction.access$0((LoadAction)this.this$1).sb.toString());
                    }
                };
                new ProgressMonitorDialog(DbPlugin.getDefault().getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                DbPlugin.getDefault().showInformationMessage(Messages.getString("CopyCreateStatementAction.6"));
            }
        }

        static /* synthetic */ CopyCreateStatementAction access$0(LoadAction loadAction) {
            return loadAction.CopyCreateStatementAction.this;
        }
    }
}

